/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.Enumerable;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.NonDet;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SetSort
extends ADT
implements Cloneable,
Enumerable,
Serializable {
    private static IOACategory cat = IOACategory.getInstance((String)SetSort.class.getName());
    protected Set set = new HashSet();
    static /* synthetic */ Class class$0;

    public static SetSort empty() {
        return new SetSort();
    }

    public static SetSort singleton(Object o) {
        return new SetSort().insert(o);
    }

    public static SetSort insert(Object o, SetSort s) {
        return s.insert(o);
    }

    public static SetSort delete(Object o, SetSort s) {
        return s.delete(o);
    }

    public static BoolSort isIn(Object o, SetSort s) {
        return BoolSort.lit(s.contains(o));
    }

    public static SetSort union(SetSort s1, SetSort s2) {
        return s1.union(s2);
    }

    public static SetSort intersection(SetSort s1, SetSort s2) {
        return s1.intersection(s2);
    }

    public static SetSort difference(SetSort s1, SetSort s2) {
        return s1.difference(s2);
    }

    public static BoolSort isSupset(SetSort s1, SetSort s2) {
        return BoolSort.lit(s1.isSupset(s2));
    }

    public static BoolSort isSubset(SetSort s1, SetSort s2) {
        return BoolSort.lit(s1.isSubset(s2));
    }

    public static BoolSort isSubsetEq(SetSort s1, SetSort s2) {
        return BoolSort.lit(s1.isSubsetEq(s2));
    }

    public static BoolSort isSupsetEq(SetSort s1, SetSort s2) {
        return BoolSort.lit(s1.isSupsetEq(s2));
    }

    public static IntSort size(SetSort s) {
        return IntSort.lit(s.size());
    }

    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public boolean isSubset(SetSort s) {
        return s.set.containsAll(this.set) && !this.set.equals(s.set);
    }

    public boolean isSupset(SetSort s) {
        return this.set.containsAll(s.set) && !this.set.equals(s.set);
    }

    public boolean isSubsetEq(SetSort s) {
        return s.set.containsAll(this.set);
    }

    public boolean isSupsetEq(SetSort s) {
        return this.set.containsAll(s.set);
    }

    public int size() {
        return this.set.size();
    }

    public Set getSet() {
        return Collections.unmodifiableSet(this.set);
    }

    public Set getSetOrdered() {
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.set);
        return Collections.unmodifiableSet(ts);
    }

    public boolean equals(Object o) {
        return o instanceof SetSort && this.set.equals(((SetSort)o).set);
    }

    public int hashCode() {
        int result = 0;
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            result += iter.next().hashCode();
        }
        return result;
    }

    public Object clone() {
        SetSort result = new SetSort();
        result.set.addAll(this.set);
        return result;
    }

    public SetSort insert(Object o) {
        SetSort result = (SetSort)this.clone();
        result.set.add(o);
        return result;
    }

    public SetSort delete(Object o) {
        SetSort result = (SetSort)this.clone();
        result.set.remove(o);
        return result;
    }

    public SetSort union(SetSort s) {
        SetSort result = (SetSort)this.clone();
        result.set.addAll(s.set);
        return result;
    }

    public SetSort intersection(SetSort s) {
        SetSort result = (SetSort)this.clone();
        result.set.retainAll(s.set);
        return result;
    }

    public SetSort difference(SetSort s) {
        SetSort result = (SetSort)this.clone();
        result.set.removeAll(s.set);
        return result;
    }

    public static Object chooseRandom(SetSort set) {
        int i = set.size();
        if (i == 0) {
            throw new RepException("Cannot take an element out of an empty set");
        }
        return set.getSet().toArray()[NonDet.rnd.nextInt(i)];
    }

    public static SetSort rest(SetSort set) {
        int i = set.size();
        if (i == 0) {
            throw new RepException("Cannot take an element out of an empty set");
        }
        return SetSort.delete(set.getSet().toArray()[NonDet.rnd.nextInt(i)], set);
    }

    public static BoolSort isEmpty(SetSort set) {
        int i = set.size();
        return BoolSort.lit(i == 0);
    }

    public static ADT construct(Parameterization p) {
        return SetSort.empty();
    }

    public String toString() {
        Iterator iter = this.getSetOrdered().iterator();
        String result = "(";
        while (iter.hasNext()) {
            result = String.valueOf(result) + iter.next().toString() + " ";
        }
        return String.valueOf(result.trim()) + ")";
    }

    public Iterator iterator() {
        return this.set.iterator();
    }

    public SValue toSValue() {
        SList rep = new SList();
        for (ADT adt : this.getSetOrdered()) {
            rep.add((Object)adt.toSValue());
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        SetSort set = SetSort.empty();
        SList rep = (SList)svalue;
        for (SValue s : rep) {
            set.set.add(ADT.construct(s));
        }
        return set;
    }
}

