/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.NatSort;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SeqSort
extends ADT
implements Serializable {
    private Vector elements = new Vector();

    public static SeqSort empty() {
        return new SeqSort();
    }

    public static ADT construct(Parameterization p) {
        return SeqSort.empty();
    }

    public static SeqSort append(SeqSort seq, Object o) {
        SeqSort seqSort = seq;
        SeqSort result = seqSort.copy();
        return result.append(o);
    }

    public static SeqSort prepend(Object o, SeqSort seq) {
        SeqSort seqSort = seq;
        SeqSort result = seqSort.copy();
        return result.prepend(o);
    }

    public static SeqSort catenate(SeqSort pre, SeqSort suf) {
        SeqSort result = pre.copy();
        Enumeration e = suf.enumElements();
        while (e.hasMoreElements()) {
            result.append(e.nextElement());
        }
        return result;
    }

    public static BoolSort in(Object o, SeqSort seq) {
        return BoolSort.lit(seq.contains(o));
    }

    public static Object head(SeqSort seq) {
        return seq.head();
    }

    public static Object last(SeqSort seq) {
        return seq.last();
    }

    public static SeqSort tail(SeqSort seq) {
        SeqSort result = seq.copy();
        return result.tail();
    }

    public static SeqSort init(SeqSort seq) {
        SeqSort result = seq.copy();
        return result.init();
    }

    public static NatSort len(SeqSort seq) {
        return NatSort.lit(seq.length());
    }

    public static Object index(SeqSort seq, Number i) {
        return seq.elementAt((int)i.value);
    }

    protected SeqSort() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof SeqSort)) {
            return false;
        }
        SeqSort seq = (SeqSort)o;
        if (this.length() != seq.length()) {
            return false;
        }
        Enumeration n = seq.enumElements();
        Enumeration e = this.enumElements();
        while (e.hasMoreElements()) {
            if (e.nextElement().equals(n.nextElement())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Enumeration enum1 = this.elements.elements();
        while (enum1.hasMoreElements()) {
            result += enum1.nextElement().hashCode();
        }
        return result;
    }

    public String toString() {
        String s = "{";
        Enumeration e = this.enumElements();
        while (e.hasMoreElements()) {
            s = String.valueOf(s) + e.nextElement();
            if (!e.hasMoreElements()) continue;
            s = String.valueOf(s) + ", ";
        }
        return String.valueOf(s) + "}";
    }

    public String traceChange(ADT adt) {
        if (adt instanceof SeqSort) {
            SeqSort s = (SeqSort)adt;
            StringBuffer sb = new StringBuffer();
            sb.append("Sequence, elements added: {");
            for (ADT next : s.elements) {
                if (this.elements.contains(next)) continue;
                sb.append(next + " ");
            }
            sb.append('}');
            sb.append(" Elements removed: {");
            for (ADT next : this.elements) {
                if (s.elements.contains(next)) continue;
                sb.append(next + " ");
            }
            return sb.append('}').toString();
        }
        return adt.toString();
    }

    private boolean isEmpty() {
        return this.length() == 0;
    }

    private int length() {
        return this.elements.size();
    }

    private Enumeration enumElements() {
        return this.elements.elements();
    }

    private SeqSort copy() {
        SeqSort copy = new SeqSort();
        Enumeration e = this.enumElements();
        while (e.hasMoreElements()) {
            copy.append(e.nextElement());
        }
        return copy;
    }

    private boolean contains(Object o) {
        return this.elements.contains(o);
    }

    private Object head() {
        if (this.isEmpty()) {
            throw new RepException("Tried to take head of empty SeqSort.");
        }
        return this.elements.firstElement();
    }

    private Object last() {
        if (this.isEmpty()) {
            throw new RepException("Tried to take last of empty SeqSort.");
        }
        return this.elements.lastElement();
    }

    private Object elementAt(int i) {
        try {
            return this.elements.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException oobe) {
            throw new RepException("index out of bounds: " + oobe.getMessage());
        }
    }

    private SeqSort prepend(Object o) {
        this.elements.insertElementAt(o, 0);
        return this;
    }

    private SeqSort append(Object o) {
        this.elements.addElement(o);
        return this;
    }

    private SeqSort tail() {
        if (!this.isEmpty()) {
            this.elements.removeElementAt(0);
        }
        return this;
    }

    private SeqSort init() {
        if (!this.isEmpty()) {
            this.elements.removeElementAt(this.length() - 1);
        }
        return this;
    }

    private SeqSort setElementAt(Object o, int i) {
        if (i > this.length()) {
            this.elements.setSize(i);
        }
        this.elements.setElementAt(o, i);
        return this;
    }

    public SValue toSValue() {
        SList rep = new SList();
        for (ADT adt : this.elements) {
            rep.add((Object)adt.toSValue());
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        SeqSort seq = SeqSort.empty();
        SList rep = (SList)svalue;
        for (SValue s : rep) {
            seq.elements.add(ADT.construct(s));
        }
        return seq;
    }
}

