/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class RealSort
extends Number
implements Serializable {
    private static final long serialVersionUID = 6415766892297046880L;

    public static Entity construct() {
        return new RealSort(3.14);
    }

    public static ADT construct(Parameterization p) {
        return new RealSort(3.14);
    }

    protected RealSort(double value) {
        this.value = value;
        if (value == POS_INFTY) {
            throw new RepException("Can't make a RealSort with value = /infty");
        }
    }

    public static RealSort lit(double value) {
        return new RealSort(value);
    }

    public static ADT construct(Double n) {
        return new RealSort(n);
    }

    public static ADT construct(SValue svalue) {
        return new RealSort(Double.valueOf(svalue.toString()));
    }

    public static RealSort neg(Number n) {
        return RealSort.lit(-n.value);
    }

    public static RealSort abs(Number n) {
        return RealSort.lit(Math.abs(n.value));
    }

    public static RealSort pred(Number n) {
        return RealSort.lit(n.value - 1.0);
    }

    public static RealSort succ(Number n) {
        return RealSort.lit(n.value + 1.0);
    }

    public static RealSort add(Number n1, Number n2) {
        return RealSort.lit(n1.value + n2.value);
    }

    public static RealSort sub(Number n1, Number n2) {
        return RealSort.lit(n1.value - n2.value);
    }

    public static RealSort mul(Number n1, Number n2) {
        return RealSort.lit(n1.value * n2.value);
    }

    public static RealSort power(Number n1, Number n2) {
        return RealSort.lit(Math.pow(n1.value, n2.value));
    }

    public static RealSort div(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't divide by zero.");
        }
        return RealSort.lit(n1.value / n2.value);
    }

    public static RealSort mod(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't mod by zero.");
        }
        return RealSort.lit(n1.value % n2.value);
    }

    public static RealSort min(Number n1, Number n2) {
        return RealSort.lit(Math.min(n1.value, n2.value));
    }

    public static RealSort max(Number n1, Number n2) {
        return RealSort.lit(Math.max(n1.value, n2.value));
    }
}

