/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class PQSort
extends ADT
implements Serializable {
    protected Vector pq = new Vector();
    protected boolean isMaxHeap = true;

    public static PQSort empty() {
        return new PQSort();
    }

    public static PQSort addMax(ComparableADT a, PQSort p) {
        p.isMaxHeap = true;
        return p.add(a);
    }

    public static PQSort addMin(ComparableADT a, PQSort p) {
        p.isMaxHeap = false;
        return p.add(a);
    }

    public static BoolSort in(ComparableADT a, PQSort p) {
        return BoolSort.lit(p.isIn(a));
    }

    public static ComparableADT head(PQSort p) {
        return p.head();
    }

    public static PQSort tail(PQSort p) {
        return p.tail();
    }

    public static BoolSort isEmpty(PQSort p) {
        return BoolSort.lit(p.isEmpty());
    }

    public static IntSort count(ComparableADT a, PQSort p) {
        return IntSort.lit(p.count(a));
    }

    public static IntSort size(PQSort p) {
        return IntSort.lit(p.size());
    }

    public static ADT construct(Parameterization p) {
        return PQSort.empty();
    }

    public boolean isIn(ComparableADT a) {
        return this.pq.contains(a);
    }

    public ComparableADT head() {
        return (ComparableADT)this.pq.firstElement();
    }

    public boolean isEmpty() {
        return this.pq.isEmpty();
    }

    public int count(ComparableADT a) {
        return this.counthelp(a, 0, 0);
    }

    public int counthelp(ComparableADT a, int index, int result) {
        int current = this.pq.indexOf(a, index);
        if (current != -1) {
            return this.counthelp(a, ++current, ++result);
        }
        return result;
    }

    public int size() {
        return this.pq.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(PQ ");
        sb.append("(max? " + this.isMaxHeap + ") ");
        Enumeration e = this.pq.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement()).append(" ");
        }
        String result = sb.toString();
        result.trim();
        result = String.valueOf(result) + ")";
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PQSort)) {
            return false;
        }
        PQSort pq2 = (PQSort)o;
        if (this.pq.size() != pq2.pq.size()) {
            return false;
        }
        if (this.isMaxHeap != pq2.isMaxHeap) {
            return false;
        }
        Collections.sort(this.pq);
        Collections.sort(pq2.pq);
        Enumeration e1 = this.pq.elements();
        Enumeration e2 = pq2.pq.elements();
        while (e1.hasMoreElements()) {
            if (e1.nextElement().equals(e2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        Enumeration e = this.pq.elements();
        while (e.hasMoreElements()) {
            result += e.nextElement().hashCode();
        }
        return result;
    }

    protected ComparableADT leftChild(int i) {
        int indexChildL = this.leftChildIndex(i);
        return (ComparableADT)this.pq.elementAt(indexChildL);
    }

    protected int leftChildIndex(int i) {
        return i * 2 + 1;
    }

    protected ComparableADT rightChild(int i) {
        int indexChildR = this.rightChildIndex(i);
        return (ComparableADT)this.pq.elementAt(indexChildR);
    }

    protected int rightChildIndex(int i) {
        return i * 2 + 2;
    }

    protected boolean hasLeftChild(int i) {
        int size = this.pq.size();
        return size > this.leftChildIndex(i) && size >= 2;
    }

    protected boolean hasRightChild(int i) {
        int size = this.pq.size();
        return size > this.rightChildIndex(i) && size >= 3;
    }

    protected ComparableADT parent(int i) {
        return (ComparableADT)this.pq.elementAt(i);
    }

    protected void checkHeapProperty(int i) {
        ComparableADT childR;
        ComparableADT childL;
        int size = this.pq.size();
        if (i >= size) {
            return;
        }
        ComparableADT parent = this.parent(i);
        int indexChildL = this.leftChildIndex(i);
        int indexChildR = this.rightChildIndex(i);
        if (this.hasLeftChild(i) && this.shouldSwap(parent, childL = this.leftChild(i))) {
            throw new RepException("Heap property violated (parent, lchild, " + this.isMaxHeap + "): " + parent + " and " + childL + " should be swapped");
        }
        if (this.hasRightChild(i) && this.shouldSwap(parent, childR = this.rightChild(i))) {
            throw new RepException("Heap property violated (parent, rchild, " + this.isMaxHeap + "): " + parent + " and " + childR + " should be swapped");
        }
        this.checkHeapProperty(indexChildL);
        this.checkHeapProperty(indexChildR);
    }

    protected void checkHeapProperty() {
        this.checkHeapProperty(0);
    }

    public Object clone() {
        PQSort result = new PQSort();
        result.pq = (Vector)this.pq.clone();
        result.isMaxHeap = this.isMaxHeap;
        result.checkHeapProperty();
        return result;
    }

    public PQSort add(ComparableADT a) {
        PQSort result = (PQSort)this.clone();
        result.checkHeapProperty();
        result.pq.addElement(a);
        int index = result.pq.size();
        return this.addhelp(result, index - 1);
    }

    public PQSort addhelp(PQSort p, int i) {
        if (i <= 0) {
            return p;
        }
        int parenti = i % 2 == 0 ? i / 2 - 1 : (i - 1) / 2;
        ComparableADT child = p.parent(i);
        ComparableADT parent = p.parent(parenti);
        if (this.shouldSwap(parent, child)) {
            p.pq.setElementAt(child, parenti);
            p.pq.setElementAt(parent, i);
            this.addhelp(p, parenti);
        }
        p.checkHeapProperty();
        return p;
    }

    public PQSort tail() {
        PQSort result = (PQSort)this.clone();
        if (this.size() <= 2) {
            result.pq.removeElementAt(0);
            result.checkHeapProperty();
            return result;
        }
        result.pq.removeElementAt(0);
        ComparableADT last = (ComparableADT)result.pq.lastElement();
        result.pq.insertElementAt(last, 0);
        result.pq.removeElementAt(this.size() - 1);
        result.heapify(0);
        result.checkHeapProperty();
        return result;
    }

    protected void heapify(int root) {
        if (!this.hasLeftChild(root)) {
            Assert.assertTrue(!this.hasRightChild(root), "Should not have right child");
            return;
        }
        if (!this.hasRightChild(root)) {
            Assert.assertTrue(this.hasLeftChild(root), "Should have left child");
            int left = this.leftChildIndex(root);
            if (this.shouldSwap(root, left)) {
                this.swap(root, left);
                this.heapify(left);
            }
            return;
        }
        int left = this.leftChildIndex(root);
        int right = this.rightChildIndex(root);
        this.checkHeapProperty(left);
        this.checkHeapProperty(right);
        if (this.shouldSwap(root, left) && this.shouldSwap(right, left)) {
            this.swap(root, left);
            this.heapify(left);
        } else if (this.shouldSwap(left, right) && this.shouldSwap(root, right)) {
            this.swap(root, right);
            this.heapify(right);
        } else {
            Assert.assertTrue(!this.shouldSwap(root, right));
            Assert.assertTrue(!this.shouldSwap(root, left));
            this.checkHeapProperty(root);
        }
    }

    protected boolean shouldSwap(ComparableADT parent, ComparableADT child) {
        if (this.isMaxHeap) {
            return parent.compareTo(child) < 0;
        }
        return parent.compareTo(child) > 0;
    }

    protected boolean shouldSwap(int rootIndex, int childIndex) {
        return this.shouldSwap(this.get(rootIndex), this.get(childIndex));
    }

    protected ComparableADT get(int i) {
        if (i >= this.size() || i < 0) {
            throw new RepException("Out of bounds");
        }
        return (ComparableADT)this.pq.get(i);
    }

    protected ComparableADT getLeft(int parent) {
        if (!this.hasLeftChild(parent)) {
            throw new RepException("No left child.");
        }
        return this.get(this.leftChildIndex(parent));
    }

    protected ComparableADT getRight(int parent) {
        if (!this.hasRightChild(parent)) {
            throw new RepException("No right child.");
        }
        return this.get(this.rightChildIndex(parent));
    }

    protected void swap(int i, int j) {
        Object iobj = this.pq.get(i);
        Object jobj = this.pq.get(j);
        this.pq.set(i, jobj);
        this.pq.set(j, iobj);
    }

    public SValue toSValue() {
        SList rep = new SList();
        SString minOrMax = new SString(this.isMaxHeap ? "max" : "min");
        rep.add((Object)minOrMax);
        SList items = new SList();
        for (ADT adt : this.pq) {
            items.add((Object)adt.toSValue());
        }
        rep.add((Object)items);
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        PQSort pq = PQSort.empty();
        SList rep = (SList)svalue;
        pq.isMaxHeap = rep.getSValue(0).toString().equals("max");
        SList items = (SList)rep.getSValue(1);
        for (SValue s : items) {
            pq = pq.add((ComparableADT)ADT.construct(s));
        }
        return pq;
    }
}

