/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SValue;

public class Number
extends ComparableADT {
    public static double POS_INFTY = Double.POSITIVE_INFINITY;
    protected double value;

    public double value() {
        return this.value;
    }

    public int compareTo(Object o) {
        Number c = (Number)o;
        if (this.value < c.value) {
            return -1;
        }
        if (this.value == c.value) {
            return 0;
        }
        return 1;
    }

    public static BoolSort lt(Number n1, Number n2) {
        return BoolSort.lit(n1.compareTo(n2) < 0);
    }

    public static BoolSort lte(Number n1, Number n2) {
        return BoolSort.lit(n1.compareTo(n2) <= 0);
    }

    public static BoolSort gt(Number n1, Number n2) {
        return BoolSort.lit(n1.compareTo(n2) > 0);
    }

    public static BoolSort gte(Number n1, Number n2) {
        return BoolSort.lit(n1.compareTo(n2) >= 0);
    }

    public SValue toSValue() {
        SNumber rep = new SNumber(String.valueOf(this.value));
        return this.toSValue((SValue)rep);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        return this.compareTo((Number)o) == 0;
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }
}

