/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.NotEnumerableException;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class NatSort
extends Number
implements Serializable {
    private static final long serialVersionUID = -2023619242183759012L;
    public static int MAX_LOOK = 100;

    public static Entity construct() {
        return new NatSort(3.0);
    }

    public static ADT construct(Parameterization p) {
        return new NatSort(3.0);
    }

    protected NatSort(double value) {
        this.value = value;
        if (value < 0.0) {
            throw new RepException("Can't make a NatSort with value < 0:" + value);
        }
        if ((double)((int)value) != value) {
            throw new RepException("Can't make an IntSort with decimals:" + value);
        }
        if (value == POS_INFTY) {
            throw new RepException("Can't make a NatSort with value = /infty");
        }
    }

    public static NatSort lit(double value) {
        return new NatSort(value);
    }

    public static Entity construct(int value) {
        return new NatSort(value);
    }

    public static NatSort abs(Number n) {
        return NatSort.lit(Math.abs(n.value));
    }

    public static NatSort pred(Number n) {
        return NatSort.lit(n.value - 1.0);
    }

    public static NatSort succ(Number n) {
        return NatSort.lit(n.value + 1.0);
    }

    public static NatSort add(Number n1, Number n2) {
        return NatSort.lit(n1.value + n2.value);
    }

    public static NatSort sub(Number n1, Number n2) {
        return NatSort.lit(n1.value - n2.value);
    }

    public static NatSort mul(Number n1, Number n2) {
        return NatSort.lit(n1.value * n2.value);
    }

    public static NatSort power(Number n1, Number n2) {
        return NatSort.lit(Math.pow(n1.value, n2.value));
    }

    public static NatSort intdiv(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("NatSort: Can't divide by zero.");
        }
        return NatSort.lit((int)n1.value / (int)n2.value);
    }

    public static NatSort mod(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("NatSort: Can't mod by zero.");
        }
        return NatSort.lit(n1.value % n2.value);
    }

    public static NatSort min(Number n1, Number n2) {
        return NatSort.lit(Math.min(n1.value, n2.value));
    }

    public static NatSort max(Number n1, Number n2) {
        return NatSort.lit(Math.max(n1.value, n2.value));
    }

    public static ADT construct(SValue svalue) {
        return new NatSort(Integer.valueOf(svalue.toString()).intValue());
    }

    public static ADT construct(Double d) {
        return new NatSort(d.intValue());
    }

    protected Set getElementsImpl() throws NotEnumerableException {
        HashSet<NatSort> result = new HashSet<NatSort>();
        int i = 0;
        while (i < MAX_LOOK) {
            result.add(NatSort.lit(i));
            ++i;
        }
        return result;
    }
}

