/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.Enumerable;
import com.veromodo.tioa.runtime.adt.IntSort;
import com.veromodo.tioa.runtime.adt.NonDet;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class MsetSort
extends ADT
implements Cloneable,
Enumerable,
Serializable {
    protected Map map = new HashMap();

    public static ADT construct(Parameterization p) {
        return MsetSort.empty();
    }

    public static MsetSort empty() {
        return new MsetSort();
    }

    public static MsetSort singleton(Object o) {
        return new MsetSort().insert(o);
    }

    public static MsetSort insert(Object o, MsetSort s) {
        return s.insert(o);
    }

    public static MsetSort delete(Object o, MsetSort s) {
        return s.delete(o);
    }

    public static BoolSort isIn(Object o, MsetSort s) {
        return BoolSort.lit(s.count(o) > 0);
    }

    public static MsetSort union(MsetSort s1, MsetSort s2) {
        return s1.union(s2);
    }

    public static MsetSort intersection(MsetSort s1, MsetSort s2) {
        return s1.intersection(s2);
    }

    public static MsetSort difference(MsetSort s1, MsetSort s2) {
        return s1.difference(s2);
    }

    public static BoolSort isSubset(MsetSort s1, MsetSort s2) {
        return BoolSort.lit(s1.isSubset(s2));
    }

    public static BoolSort isSubsetEq(MsetSort s1, MsetSort s2) {
        return BoolSort.lit(s1.isSubsetEq(s2));
    }

    public static BoolSort isSupset(MsetSort s1, MsetSort s2) {
        return BoolSort.lit(s1.isSupset(s2));
    }

    public static BoolSort isSupsetEq(MsetSort s1, MsetSort s2) {
        return BoolSort.lit(s1.isSupsetEq(s2));
    }

    public static IntSort size(MsetSort s) {
        return IntSort.lit(s.size());
    }

    public static IntSort count(Object o, MsetSort s) {
        return IntSort.lit(s.count(o));
    }

    public static ADT chooseRandom(MsetSort s) {
        return s.chooseRandom();
    }

    public static BoolSort isEmpty(MsetSort set) {
        int i = set.size();
        return BoolSort.lit(i == 0);
    }

    public static MsetSort rest(MsetSort set) {
        return set.delete(set.chooseRandom());
    }

    public boolean equals(Object o) {
        if (!(o instanceof MsetSort)) {
            return false;
        }
        MsetSort m = (MsetSort)o;
        return this.isSubsetEq(m) && this.isSupsetEq(m);
    }

    public int hashCode() {
        int result = 0;
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            result += iter.next().hashCode();
        }
        return result;
    }

    public int count(Object o) {
        if (this.map.containsKey(o)) {
            Integer i = (Integer)this.map.get(o);
            return i;
        }
        return 0;
    }

    public int size() {
        int total = 0;
        Collection values = this.map.values();
        for (Integer i : values) {
            total += i.intValue();
        }
        return total;
    }

    public ADT chooseRandom() {
        int elt = this.size();
        if (elt == 0) {
            throw new RepException("No elements in MSet");
        }
        elt = NonDet.rnd.nextInt(elt);
        Iterator i = this.map.keySet().iterator();
        ADT result = (ADT)i.next();
        Integer count = (Integer)this.map.get(result);
        while (elt > 0) {
            if ((elt -= count.intValue()) <= 0) continue;
            result = (ADT)i.next();
            count = (Integer)this.map.get(result);
        }
        return result;
    }

    public boolean isSubset(MsetSort mset) {
        for (Object key : mset.map.keySet()) {
            int thisCount = this.count(key);
            int otherCount = mset.count(key);
            if (otherCount <= thisCount) continue;
            return true;
        }
        return false;
    }

    public boolean isSupset(MsetSort mset) {
        for (Object key : this.map.keySet()) {
            int otherCount;
            int thisCount = this.count(key);
            if (thisCount <= (otherCount = mset.count(key))) continue;
            return true;
        }
        return false;
    }

    public boolean isSubsetEq(MsetSort mset) {
        return !this.isSupset(mset);
    }

    public boolean isSupsetEq(MsetSort mset) {
        return !this.isSubset(mset);
    }

    public String toString() {
        String result = "(";
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.entrySet());
        for (Map.Entry entry : ts) {
            Object key = entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value == 0) continue;
            result = String.valueOf(result) + "(" + key + " " + value + ") ";
        }
        return String.valueOf(result.trim()) + ")";
    }

    public Object clone() {
        MsetSort result = new MsetSort();
        result.map.putAll(this.map);
        return result;
    }

    public MsetSort insert(Object o) {
        MsetSort result = (MsetSort)this.clone();
        result.map.put(o, new Integer(this.count(o) + 1));
        return result;
    }

    public MsetSort delete(Object o) {
        MsetSort result = (MsetSort)this.clone();
        if (this.count(o) > 1) {
            result.map.put(o, new Integer(this.count(o) - 1));
            return result;
        }
        if (this.count(o) > 0) {
            result.map.remove(o);
            return result;
        }
        return result;
    }

    public MsetSort union(MsetSort mset) {
        MsetSort result = (MsetSort)this.clone();
        for (Map.Entry entry : mset.map.entrySet()) {
            Object key = entry.getKey();
            int newCount = Math.max((Integer)entry.getValue(), this.count(key));
            result.map.put(key, new Integer(newCount));
        }
        return result;
    }

    public MsetSort intersection(MsetSort mset) {
        MsetSort result = new MsetSort();
        for (Map.Entry entry : mset.map.entrySet()) {
            Object key = entry.getKey();
            int newCount = Math.min((Integer)entry.getValue(), this.count(key));
            result.map.put(key, new Integer(newCount));
        }
        return result;
    }

    public MsetSort difference(MsetSort mset) {
        MsetSort result = (MsetSort)this.clone();
        for (Map.Entry entry : mset.map.entrySet()) {
            Object key = entry.getKey();
            int newCount = Math.max(this.count(key) - (Integer)entry.getValue(), 0);
            if (newCount == 0) {
                result.map.remove(key);
                continue;
            }
            result.map.put(key, new Integer(newCount));
        }
        return result;
    }

    public Iterator iterator() {
        ArrayList<ADT> elements = new ArrayList<ADT>();
        for (ADT adt : this.map.keySet()) {
            int count = (Integer)this.map.get(adt);
            int i = 0;
            while (i < count) {
                elements.add(adt);
                ++i;
            }
        }
        return elements.iterator();
    }

    public SValue toSValue() {
        SList rep = new SList();
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.keySet());
        for (ADT adt : ts) {
            int count = (Integer)this.map.get(adt);
            SList entry = new SList();
            entry.add((Object)adt.toSValue());
            entry.add((Object)new SNumber((float)count));
            rep.add((Object)entry);
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        MsetSort set = MsetSort.empty();
        SList rep = (SList)svalue;
        for (SList entry : rep) {
            ADT adt = ADT.construct(entry.getSValue(0));
            int count = ((SNumber)entry.get(1)).intValue();
            set.map.put(adt, new Integer(count));
        }
        return set;
    }
}

