/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.Hashable;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RealSort;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class MappSort
extends ADT
implements Cloneable,
Serializable {
    private static IOACategory cat = IOACategory.getInstance((String)MappSort.class.getName());
    private Map map = new HashMap();
    static /* synthetic */ Class class$0;

    public static MappSort empty() {
        return new MappSort();
    }

    public static Object get(Object[] args) {
        MappSort mappSort = (MappSort)args[0];
        ADT[] domainValues = new ADT[args.length - 1];
        int i = 1;
        while (i < args.length) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return mappSort.get(key);
    }

    public static Object minValue(MappSort mapp) {
        return mapp.minValue();
    }

    public static MappSort update(Object[] args) {
        MappSort mappSort = (MappSort)args[0];
        ADT rangeValue = (ADT)args[args.length - 1];
        ADT[] domainValues = new ADT[args.length - 2];
        int i = 1;
        while (i < args.length - 1) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return mappSort.update(key, rangeValue);
    }

    public static BoolSort defined(Object[] args) {
        MappSort mappSort = (MappSort)args[0];
        ADT[] domainValues = new ADT[args.length - 1];
        int i = 1;
        while (i < args.length) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return BoolSort.lit(mappSort.defined(key));
    }

    public static ADT construct(Parameterization p) {
        return MappSort.empty();
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object minValue() {
        if (this.map.values().isEmpty()) {
            return null;
        }
        Iterator i = this.map.values().iterator();
        Object next = i.next();
        if (!(next instanceof RealSort)) {
            throw new RuntimeException("Only Reals supported by Mapp.");
        }
        RealSort min = (RealSort)next;
        while (i.hasNext()) {
            RealSort r = (RealSort)i.next();
            if (!RealSort.lt(r, min).booleanValue()) continue;
            min = r;
        }
        return min;
    }

    public boolean defined(Object key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object o) {
        return o instanceof MappSort && this.map.equals(((MappSort)o).map);
    }

    public int hashCode() {
        int hashVal = 0;
        Iterator<Object> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            hashVal = 17 * hashVal ^ i.next().hashCode();
        }
        i = this.map.values().iterator();
        while (i.hasNext()) {
            hashVal = 17 * hashVal ^ i.next().hashCode();
        }
        return hashVal;
    }

    public Object clone() {
        MappSort copy = new MappSort();
        copy.map.putAll(this.map);
        return copy;
    }

    public MappSort update(Object key, Object value) {
        MappSort result = (MappSort)this.clone();
        result.map.put(key, value);
        return result;
    }

    public SValue toSValue() {
        SList rep = new SList();
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.keySet());
        for (Hashable key : ts) {
            ADT value = (ADT)this.map.get(key);
            SList entry = new SList();
            entry.add((Object)key.toSValue());
            entry.add((Object)value.toSValue());
            rep.add((Object)entry);
        }
        return this.toSValue((SValue)rep);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Mapp{");
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.keySet());
        for (Hashable key : ts) {
            ADT value = (ADT)this.map.get(key);
            sb.append("[");
            sb.append(key.toString());
            sb.append(" -> ");
            sb.append(value.toString());
            sb.append("] ");
        }
        sb.append("}");
        return sb.toString();
    }

    public String traceChange(ADT t2) {
        if (t2 instanceof MappSort) {
            MappSort m2 = (MappSort)t2;
            if (!this.map.keySet().equals(m2.map.keySet())) {
                return m2.toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Map, modified entries: {");
            for (Object key : this.map.keySet()) {
                ADT value2;
                ADT value1 = (ADT)this.get(key);
                if (value1.equals(value2 = (ADT)m2.get(key))) continue;
                sb.append("[" + key.toString() + " -> " + value1.traceChange(value2) + "]");
            }
            return sb.append('}').toString();
        }
        return t2.toString();
    }

    public static ADT construct(SValue svalue) {
        MappSort mappSort = MappSort.empty();
        SList rep = (SList)svalue;
        for (SList entry : rep) {
            Hashable key = new Hashable(entry.getSValue(0));
            ADT value = ADT.construct(entry.getSValue(1));
            mappSort.map.put(key, value);
        }
        return mappSort;
    }
}

