/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.Hashable;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class MapSort
extends ADT
implements Cloneable,
Serializable {
    private static IOACategory cat = IOACategory.getInstance((String)MapSort.class.getName());
    private Map map = new HashMap();
    static /* synthetic */ Class class$0;

    public static MapSort empty() {
        return new MapSort();
    }

    public static Object get(Object[] args) {
        MapSort mapSort = (MapSort)args[0];
        ADT[] domainValues = new ADT[args.length - 1];
        int i = 1;
        while (i < args.length) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return mapSort.get(key);
    }

    public static MapSort update(Object[] args) {
        MapSort mapSort = (MapSort)args[0];
        ADT rangeValue = (ADT)args[args.length - 1];
        ADT[] domainValues = new ADT[args.length - 2];
        int i = 1;
        while (i < args.length - 1) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return mapSort.update(key, rangeValue);
    }

    public static BoolSort defined(Object[] args) {
        MapSort mapSort = (MapSort)args[0];
        ADT[] domainValues = new ADT[args.length - 1];
        int i = 1;
        while (i < args.length) {
            domainValues[i - 1] = (ADT)args[i];
            ++i;
        }
        Hashable key = new Hashable(domainValues);
        return BoolSort.lit(mapSort.defined(key));
    }

    public static ADT construct(Parameterization p) {
        return MapSort.empty();
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean defined(Object key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object o) {
        return o instanceof MapSort && this.map.equals(((MapSort)o).map);
    }

    public int hashCode() {
        int hashVal = 0;
        Iterator<Object> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            hashVal = 17 * hashVal ^ i.next().hashCode();
        }
        i = this.map.values().iterator();
        while (i.hasNext()) {
            hashVal = 17 * hashVal ^ i.next().hashCode();
        }
        return hashVal;
    }

    public Object clone() {
        MapSort copy = new MapSort();
        copy.map.putAll(this.map);
        return copy;
    }

    public MapSort update(Object key, Object value) {
        MapSort result = (MapSort)this.clone();
        result.map.put(key, value);
        return result;
    }

    public SValue toSValue() {
        SList rep = new SList();
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.keySet());
        for (Hashable key : ts) {
            ADT value = (ADT)this.map.get(key);
            SList entry = new SList();
            entry.add((Object)key.toSValue());
            entry.add((Object)value.toSValue());
            rep.add((Object)entry);
        }
        return this.toSValue((SValue)rep);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Map{");
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.map.keySet());
        for (Hashable key : ts) {
            ADT value = (ADT)this.map.get(key);
            sb.append("[");
            sb.append(key.toString());
            sb.append(" -> ");
            sb.append(value.toString());
            sb.append("] ");
        }
        sb.append("}");
        return sb.toString();
    }

    public String traceChange(ADT t2) {
        if (t2 instanceof MapSort) {
            MapSort m2 = (MapSort)t2;
            if (!this.map.keySet().equals(m2.map.keySet())) {
                return m2.toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Map, modified entries: {");
            for (Object key : this.map.keySet()) {
                ADT value2;
                ADT value1 = (ADT)this.get(key);
                if (value1.equals(value2 = (ADT)m2.get(key))) continue;
                sb.append("[" + key.toString() + " -> " + value1.traceChange(value2) + "]");
            }
            return sb.append('}').toString();
        }
        return t2.toString();
    }

    public static ADT construct(SValue svalue) {
        MapSort mapSort = MapSort.empty();
        SList rep = (SList)svalue;
        for (SList entry : rep) {
            Hashable key = new Hashable(entry.getSValue(0));
            ADT value = ADT.construct(entry.getSValue(1));
            mapSort.map.put(key, value);
        }
        return mapSort;
    }
}

