/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class IntSort
extends Number
implements Serializable {
    private static final long serialVersionUID = -8992554748796286563L;

    public static Entity construct() {
        return new IntSort(-3.0);
    }

    public static ADT construct(Parameterization p) {
        return new IntSort(-3.0);
    }

    protected IntSort(double value) {
        this.value = value;
        if ((double)((int)value) != value) {
            throw new RepException("Can't make an IntSort with decimals: " + value);
        }
        if (value == POS_INFTY) {
            throw new RepException("Can't make an IntSort with value = /infty");
        }
    }

    public static IntSort lit(double value) {
        return new IntSort(value);
    }

    public static Entity construct(int value) {
        return IntSort.lit(value);
    }

    public static IntSort floor(Number n) {
        return IntSort.lit((int)n.value);
    }

    public static IntSort neg(Number n) {
        return IntSort.lit(-n.value);
    }

    public static IntSort abs(Number n) {
        return IntSort.lit(Math.abs(n.value));
    }

    public static IntSort pred(Number n) {
        return IntSort.lit(n.value - 1.0);
    }

    public static IntSort succ(Number n) {
        return IntSort.lit(n.value + 1.0);
    }

    public static IntSort add(Number n1, Number n2) {
        return IntSort.lit(n1.value + n2.value);
    }

    public static IntSort sub(Number n1, Number n2) {
        return IntSort.lit(n1.value - n2.value);
    }

    public static IntSort mul(Number n1, Number n2) {
        return IntSort.lit(n1.value * n2.value);
    }

    public static IntSort power(Number n1, Number n2) {
        return IntSort.lit(Math.pow(n1.value, n2.value));
    }

    public static IntSort intdiv(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't divide by zero.");
        }
        return IntSort.lit((int)n1.value / (int)n2.value);
    }

    public static IntSort mod(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't mod by zero.");
        }
        return IntSort.lit(n1.value % n2.value);
    }

    public static IntSort min(Number n1, Number n2) {
        return IntSort.lit(Math.min(n1.value, n2.value));
    }

    public static IntSort max(Number n1, Number n2) {
        return IntSort.lit(Math.max(n1.value, n2.value));
    }

    public static ADT construct(SValue svalue) {
        return new IntSort(Integer.valueOf(svalue.toString()).intValue());
    }

    public static ADT construct(Double d) {
        return new IntSort(d.intValue());
    }
}

