/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.EnumRepException;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class EnumSort
extends ADT
implements Serializable {
    public static final String FIELD_DELIMITER = "%";
    private List elements;
    private int index;

    public static ADT construct(Parameterization p) {
        Object[] eltNames = (Object[])p.getShorthandInfo()[0];
        String eltNamesString = "";
        int i = 0;
        while (i < eltNames.length) {
            eltNamesString = String.valueOf(eltNamesString) + (String)eltNames[i];
            if (i < eltNames.length - 1) {
                eltNamesString = String.valueOf(eltNamesString) + FIELD_DELIMITER;
            }
            ++i;
        }
        return new EnumSort(eltNamesString, (String)eltNames[0]);
    }

    public static EnumSort construct(String elts, String elt) {
        return new EnumSort(elts, elt);
    }

    public static EnumSort succ(EnumSort enum1) {
        return enum1.succ();
    }

    protected EnumSort(List elts, int i) {
        this.elements = elts;
        this.index = i;
        if (this.index < 0) {
            throw new EnumRepException("Trying to create a new EnumSort, but the given value (" + i + ") isn't in the valid range of ", elts);
        }
    }

    protected EnumSort(List elts, String elt) {
        this(elts, elts.indexOf(elt));
    }

    protected EnumSort(String elts, String elt) {
        this(EnumSort.stringToList(elts), elt);
    }

    private static List stringToList(String input) {
        StringTokenizer tk = new StringTokenizer(input, FIELD_DELIMITER);
        Vector<String> v = new Vector<String>();
        while (tk.hasMoreTokens()) {
            v.add(tk.nextToken());
        }
        return v;
    }

    private EnumSort succ() {
        if (this.index + 1 < this.elements.size()) {
            return new EnumSort(this.elements, this.index + 1);
        }
        return new EnumSort(this.elements, 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnumSort)) {
            return false;
        }
        EnumSort enum1 = (EnumSort)obj;
        if (this.elements.size() != enum1.elements.size()) {
            return false;
        }
        if (this.index != enum1.index) {
            return false;
        }
        Iterator n = enum1.elements.iterator();
        Iterator e = this.elements.iterator();
        while (e.hasNext()) {
            if (e.next().equals(n.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.elements.get(this.index).hashCode();
    }

    public String toString() {
        if (this.elements.size() == 0) {
            return "(enum: uninitialized)";
        }
        return (String)this.elements.get(this.index);
    }

    public Iterator iterElements() {
        return Collections.unmodifiableCollection(this.elements).iterator();
    }

    public boolean contains(String s) {
        return this.elements.contains(s);
    }

    public String stringValue() {
        return (String)this.elements.get(this.index);
    }

    public SValue toSValue() {
        SList rep = new SList();
        rep.add((Object)new SNumber((float)this.index));
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            rep.add((Object)new SString((String)i.next()));
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        SList rep = (SList)svalue;
        Iterator i = rep.iterator();
        int index = ((SNumber)i.next()).intValue();
        Vector<String> elements = new Vector<String>();
        while (i.hasNext()) {
            elements.add(((SString)i.next()).toString());
        }
        return new EnumSort(elements, index);
    }

    public Set getElements() {
        Assert.assertTrue(this.elements.size() > 0);
        HashSet<EnumSort> result = new HashSet<EnumSort>();
        int i = 0;
        while (i < this.elements.size()) {
            result.add(new EnumSort(this.elements, i));
            ++i;
        }
        return result;
    }

    public boolean isEnumerable() {
        return true;
    }
}

