/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class CharSort
extends ComparableADT
implements Serializable {
    protected char charValue;

    public static CharSort lit(Character c) {
        return new CharSort(c);
    }

    public static CharSort lit(char c) {
        return new CharSort(new Character(c));
    }

    public int compareTo(Object o) {
        CharSort c = (CharSort)o;
        if (this.charValue < c.charValue) {
            return -1;
        }
        if (this.charValue == c.charValue) {
            return 0;
        }
        return 1;
    }

    public static BoolSort lt(CharSort c1, CharSort c2) {
        return BoolSort.lit(c1.compareTo(c2) < 0);
    }

    public static BoolSort lte(CharSort c1, CharSort c2) {
        return BoolSort.lit(c1.compareTo(c2) <= 0);
    }

    public static BoolSort gt(CharSort c1, CharSort c2) {
        return BoolSort.lit(c1.compareTo(c2) > 0);
    }

    public static BoolSort gte(CharSort c1, CharSort c2) {
        return BoolSort.lit(c1.compareTo(c2) >= 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharSort)) {
            return false;
        }
        CharSort c = (CharSort)o;
        return this.compareTo(c) == 0;
    }

    public String toString() {
        return String.valueOf(this.charValue);
    }

    public int hashCode() {
        return new Character(this.charValue).hashCode();
    }

    public CharSort(Character c) {
        this.charValue = c.charValue();
    }

    public static ADT construct(Parameterization p) {
        return new CharSort(new Character('a'));
    }

    public SValue toSValue() {
        SString rep = new SString(String.valueOf(this.charValue));
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        return new CharSort(new Character(svalue.toString().charAt(0)));
    }
}

