/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.NotEnumerableException;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class BoolSort
extends ADT
implements Serializable {
    private static final BoolSort FALSE = new BoolSort(false);
    private static final BoolSort TRUE = new BoolSort(true);
    private static IOACategory cat = IOACategory.getInstance((String)BoolSort.class.getName());
    private boolean value;
    static /* synthetic */ Class class$0;

    public static BoolSort False() {
        return FALSE;
    }

    public static BoolSort True() {
        return TRUE;
    }

    public static BoolSort not(Object op) {
        return BoolSort.lit(op.equals(FALSE));
    }

    public static BoolSort and(BoolSort op1, BoolSort op2) {
        return BoolSort.lit(op1.equals(TRUE) && op2.equals(TRUE));
    }

    public static BoolSort or(BoolSort op1, BoolSort op2) {
        return BoolSort.lit(op1.equals(TRUE) || op2.equals(TRUE));
    }

    public static BoolSort implies(BoolSort op1, BoolSort op2) {
        return BoolSort.lit(op1.equals(FALSE) || op2.equals(TRUE));
    }

    public static BoolSort iff(BoolSort op1, BoolSort op2) {
        return BoolSort.lit(op1.equals(op2));
    }

    public static BoolSort lit(boolean b) {
        return b ? BoolSort.True() : BoolSort.False();
    }

    public static ADT construct(Parameterization p) {
        return TRUE;
    }

    private BoolSort(boolean value) {
        this.value = value;
        if (value && TRUE != null || !value && FALSE != null) {
            throw new Error("Attempt to reinitialize canonical BoolSort.");
        }
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public boolean booleanValue() {
        return this.value;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.value ? TRUE : FALSE;
    }

    public SValue toSValue() {
        SString rep = new SString(String.valueOf(this.value));
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        return svalue.toString().equals("true") ? TRUE : FALSE;
    }

    protected Set getElementsImpl() throws NotEnumerableException {
        HashSet<BoolSort> result = new HashSet<BoolSort>();
        result.add(TRUE);
        result.add(FALSE);
        return result;
    }

    public boolean isEnumerable() {
        return true;
    }
}

