/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.SeqSort;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class BTreeSort
extends ADT
implements Serializable,
Cloneable,
SPrintable {
    protected BTreeSort[] children = null;
    protected ComparableADT[] keys;
    protected BTreeSort parent;
    private static final int t = 2;
    public static boolean debug = false;

    public BTreeSort() {
        this.keys = null;
        this.parent = null;
    }

    public BTreeSort(ComparableADT a) {
        this.keys = new ComparableADT[]{a};
        this.parent = null;
    }

    public static BTreeSort empty() {
        return new BTreeSort();
    }

    public static BTreeSort singleton(ComparableADT a) {
        return new BTreeSort(a);
    }

    public static BTreeSort insert(ComparableADT a, BTreeSort t) {
        if (t == null) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        if (t.keys == null) {
            return new BTreeSort(a);
        }
        return t.insert(a);
    }

    public static BTreeSort delete(ComparableADT a, BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree. ");
        }
        return t.delete(a);
    }

    public static BoolSort isIn(ComparableADT a, BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(t.in(a));
    }

    public static SeqSort children(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.children();
    }

    public static BTreeSort parent(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.parent;
    }

    public static ComparableADT successor(ComparableADT a, BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.successor(a);
    }

    public static ComparableADT predecessor(ComparableADT a, BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.predecessor(a);
    }

    public static ComparableADT minimum(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.minimum();
    }

    public static ComparableADT maximum(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.maximum();
    }

    public static SeqSort keys(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.keys();
    }

    public static BTreeSort search(ComparableADT a, BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.search(a);
    }

    public static BoolSort isLeaf(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(t.children == null);
    }

    public static SeqSort inOrderWalk(BTreeSort t) {
        if (BTreeSort.isNullBTree(t)) {
            throw new RuntimeException("Given tree is null. Cannot perform operation on null tree.");
        }
        return t.inOrderWalk();
    }

    public Object clone() {
        BTreeSort.checkRep(this);
        BTreeSort result = BTreeSort.copyBTree(this, this.parent);
        BTreeSort.checkRep(result);
        return result;
    }

    private static BTreeSort copyBTree(BTreeSort tr, BTreeSort parent) {
        int i;
        BTreeSort newTree = new BTreeSort();
        newTree.parent = parent;
        if (tr.keys == null) {
            newTree.keys = null;
        } else {
            newTree.keys = new ComparableADT[tr.keys.length];
            i = 0;
            while (i < tr.keys.length) {
                newTree.keys[i] = tr.keys[i];
                ++i;
            }
        }
        if (tr.children == null) {
            newTree.children = null;
        } else {
            newTree.children = new BTreeSort[tr.children.length];
            i = 0;
            while (i < tr.children.length) {
                newTree.children[i] = BTreeSort.copyBTree(tr.children[i], newTree);
                ++i;
            }
        }
        return newTree;
    }

    public BTreeSort insert(ComparableADT a) {
        BTreeSort.checkRep(this);
        if (BTreeSort.isNullBTree(this)) {
            return new BTreeSort(a);
        }
        if (this.search(a) != null) {
            return (BTreeSort)this.clone();
        }
        BTreeSort copy = (BTreeSort)this.clone();
        if (copy.keys.length == 3) {
            BTreeSort s;
            copy.parent = s = new BTreeSort();
            s.children = new BTreeSort[]{copy};
            BTreeSort.splitChild(s, 0);
            this.BTreeInsertNonFull(s, a);
            BTreeSort.checkRep(s);
            return s;
        }
        this.BTreeInsertNonFull(copy, a);
        BTreeSort.checkRep(copy);
        return copy;
    }

    private static void splitChild(BTreeSort x, int i) {
        int j;
        BTreeSort y = x.children[i];
        BTreeSort z = new BTreeSort();
        z.keys = new ComparableADT[1];
        ComparableADT median = y.keys[1];
        ComparableADT[] newKeys = new ComparableADT[1];
        int j2 = 0;
        while (j2 < 1) {
            z.keys[j2] = y.keys[j2 + 2];
            newKeys[j2] = y.keys[j2];
            ++j2;
        }
        y.keys = newKeys;
        if (!y.isLeaf()) {
            z.children = new BTreeSort[2];
            BTreeSort[] newChildren = new BTreeSort[2];
            j = 0;
            while (j < 2) {
                z.children[j] = y.children[j + 2];
                z.children[j].parent = z;
                newChildren[j] = y.children[j];
                ++j;
            }
            y.children = newChildren;
        }
        BTreeSort[] newXChildren = new BTreeSort[x.children.length + 1];
        j = 0;
        while (j <= i) {
            newXChildren[j] = x.children[j];
            ++j;
        }
        j = x.children.length - 1;
        while (j > i) {
            newXChildren[j + 1] = x.children[j];
            --j;
        }
        newXChildren[i + 1] = z;
        z.parent = x;
        x.children = newXChildren;
        int len = x.keys != null ? x.keys.length : 0;
        ComparableADT[] newXkeys = new ComparableADT[len + 1];
        int j3 = 0;
        while (j3 < i) {
            newXkeys[j3] = x.keys[j3];
            ++j3;
        }
        j3 = len - 1;
        while (j3 >= i) {
            newXkeys[j3 + 1] = x.keys[j3];
            --j3;
        }
        newXkeys[i] = median;
        x.keys = newXkeys;
    }

    private void BTreeInsertNonFull(BTreeSort x, ComparableADT k) {
        int i = 0;
        if (x.isLeaf()) {
            ComparableADT[] newXkeys = new ComparableADT[x.keys.length + 1];
            while (i < x.keys.length && x.keys[i].compareTo(k) < 0) {
                newXkeys[i] = x.keys[i];
                ++i;
            }
            int j = x.keys.length - 1;
            while (j >= i) {
                newXkeys[j + 1] = x.keys[j];
                --j;
            }
            newXkeys[i] = k;
            x.keys = newXkeys;
        } else {
            int len;
            i = 0;
            while (i < x.keys.length && k.compareTo(x.keys[i]) > 0) {
                ++i;
            }
            int n = len = x.children[i].keys != null ? x.children[i].keys.length : 0;
            if (len == 3) {
                BTreeSort.splitChild(x, i);
                if (k.compareTo(x.keys[i]) > 0) {
                    ++i;
                }
            }
            this.BTreeInsertNonFull(x.children[i], k);
        }
    }

    public BTreeSort delete(ComparableADT k) {
        BTreeSort.checkRep(this);
        BTreeSort result = (BTreeSort)this.clone();
        BTreeSort x = result.search(k);
        if (x == null) {
            return result;
        }
        if (!x.isLeaf()) {
            ComparableADT k1 = x.successor(k);
            BTreeSort y = x.search(k1);
            int i = 0;
            while (i < x.keys.length) {
                if (x.keys[i].equals(k)) {
                    x.keys[i] = k1;
                }
                ++i;
            }
            y.keys[0] = k;
            x = y;
        }
        if (x.parent == null && x.keys.length == 1) {
            return new BTreeSort();
        }
        ComparableADT[] newKeys = new ComparableADT[x.keys.length - 1];
        int i = 0;
        while (i < x.keys.length) {
            if (x.keys[i].compareTo(k) < 0) {
                newKeys[i] = x.keys[i];
            } else if (x.keys[i].compareTo(k) > 0) {
                newKeys[i - 1] = x.keys[i];
            }
            ++i;
        }
        x.keys = newKeys;
        this.fixUnderflow(x);
        BTreeSort.checkRep(result);
        return result;
    }

    private void fixUnderflow(BTreeSort x) {
        if (x.keys.length != 0 && x.keys.length != 0) {
            return;
        }
        BTreeSort parTree = x.parent;
        if (parTree == null) {
            this.debug("Root is empty ... decreasing height.");
            if (x.keys.length == 0) {
                x.keys = x.children[0].keys;
                x.children = x.children[0].children;
                if (x.children != null) {
                    int j = 0;
                    while (j < x.children.length) {
                        x.children[j].parent = x;
                        ++j;
                    }
                }
            }
            return;
        }
        int i = 0;
        while (i < parTree.children.length) {
            if (parTree.children[i].equals(x)) break;
            ++i;
        }
        if (i != 0 && parTree.children[i - 1].keys.length >= 2) {
            this.debug(x + ":Stealing from left sibling");
            BTreeSort left = parTree.children[i - 1];
            ComparableADT[] newXKeys = new ComparableADT[x.keys.length + 1];
            newXKeys[0] = parTree.keys[i - 1];
            int j = 0;
            while (j < x.keys.length) {
                newXKeys[j + 1] = x.keys[j];
                ++j;
            }
            x.keys = newXKeys;
            parTree.keys[i - 1] = left.keys[left.keys.length - 1];
            ComparableADT[] newLeftKeys = new ComparableADT[left.keys.length - 1];
            int j2 = 0;
            while (j2 < newLeftKeys.length) {
                newLeftKeys[j2] = left.keys[j2];
                ++j2;
            }
            left.keys = newLeftKeys;
            if (left.children != null) {
                this.debug("Moving left's child too: " + left.children[left.children.length - 1]);
                BTreeSort[] newXChildren = new BTreeSort[x.children.length + 1];
                int j3 = 0;
                while (j3 < x.children.length) {
                    newXChildren[j3 + 1] = x.children[j3];
                    ++j3;
                }
                left.children[left.children.length - 1].parent = x;
                newXChildren[0] = left.children[left.children.length - 1];
                x.children = newXChildren;
                BTreeSort[] newLeftChildren = new BTreeSort[left.children.length - 1];
                int j4 = 0;
                while (j4 < left.children.length - 1) {
                    newLeftChildren[j4] = left.children[j4];
                    ++j4;
                }
                left.children = newLeftChildren;
            }
            return;
        }
        if (i != parTree.children.length - 1 && parTree.children[i + 1].keys.length >= 2) {
            this.debug(x + ":Stealing from right sibling");
            BTreeSort right = parTree.children[i + 1];
            ComparableADT[] newXKeys = new ComparableADT[x.keys.length + 1];
            newXKeys[newXKeys.length - 1] = parTree.keys[i];
            int j = 0;
            while (j < x.keys.length) {
                newXKeys[j] = x.keys[j];
                ++j;
            }
            x.keys = newXKeys;
            parTree.keys[i] = right.keys[0];
            ComparableADT[] newRightKeys = new ComparableADT[right.keys.length - 1];
            int j5 = 0;
            while (j5 < newRightKeys.length) {
                newRightKeys[j5] = right.keys[j5 + 1];
                ++j5;
            }
            right.keys = newRightKeys;
            if (right.children != null) {
                this.debug("Moving child too");
                BTreeSort[] newXChildren = new BTreeSort[x.children.length + 1];
                int j6 = 0;
                while (j6 < x.children.length) {
                    newXChildren[j6] = x.children[j6];
                    ++j6;
                }
                right.children[0].parent = x;
                newXChildren[x.children.length] = right.children[0];
                x.children = newXChildren;
                BTreeSort[] newRightChildren = new BTreeSort[right.children.length - 1];
                int j7 = 0;
                while (j7 < right.children.length - 1) {
                    newRightChildren[j7] = right.children[j7 + 1];
                    ++j7;
                }
                right.children = newRightChildren;
            }
            return;
        }
        if (i != 0) {
            int j;
            this.debug("parent: " + parTree);
            BTreeSort left = parTree.children[i - 1];
            this.debug(x + " Merging with left sibling:" + left + "and parent's key:" + parTree.keys[i - 1]);
            ComparableADT[] newKeys = new ComparableADT[2];
            int j8 = 0;
            while (j8 < left.keys.length) {
                newKeys[j8] = left.keys[j8];
                ++j8;
            }
            newKeys[left.keys.length] = parTree.keys[i - 1];
            j8 = 0;
            while (j8 < x.keys.length) {
                newKeys[left.keys.length + 1 + j8] = x.keys[j8];
                ++j8;
            }
            x.keys = newKeys;
            if (left.children != null) {
                this.debug("moving left's children");
                int lcl = left.children.length;
                BTreeSort[] newChildren = new BTreeSort[lcl + x.children.length];
                j = 0;
                while (j < lcl) {
                    newChildren[j] = left.children[j];
                    newChildren[j].parent = x;
                    ++j;
                }
                j = 0;
                while (j < x.children.length) {
                    newChildren[lcl + j] = x.children[j];
                    ++j;
                }
                x.children = newChildren;
            }
            this.debug("MergeLeft Intermediate state:" + x);
            ComparableADT[] newParKeys = new ComparableADT[parTree.keys.length - 1];
            int j9 = 0;
            while (j9 <= i - 2) {
                newParKeys[j9] = parTree.keys[j9];
                ++j9;
            }
            j9 = i;
            while (j9 < parTree.keys.length) {
                newParKeys[j9 - 1] = parTree.keys[j9];
                ++j9;
            }
            parTree.keys = newParKeys;
            BTreeSort[] newParChildren = new BTreeSort[parTree.children.length - 1];
            j = 0;
            while (j <= i - 2) {
                newParChildren[j] = parTree.children[j];
                ++j;
            }
            j = i;
            while (j < parTree.children.length) {
                newParChildren[j - 1] = parTree.children[j];
                ++j;
            }
            parTree.children = newParChildren;
            this.fixUnderflow(parTree);
        } else {
            int j;
            this.debug("parent: " + parTree);
            BTreeSort right = parTree.children[i + 1];
            this.debug(x + "Merging with right sibling:" + right + " and parent's key: " + parTree.keys[i]);
            ComparableADT[] newKeys = new ComparableADT[2];
            int j10 = 0;
            while (j10 < x.keys.length) {
                newKeys[j10] = x.keys[j10];
                ++j10;
            }
            newKeys[x.keys.length] = parTree.keys[i];
            j10 = 0;
            while (j10 < right.keys.length) {
                newKeys[x.keys.length + 1 + j10] = right.keys[j10];
                ++j10;
            }
            x.keys = newKeys;
            if (right.children != null) {
                this.debug("moving right's children");
                int xcl = x.children.length;
                BTreeSort[] newChildren = new BTreeSort[xcl + right.children.length];
                j = 0;
                while (j < xcl) {
                    newChildren[j] = x.children[j];
                    ++j;
                }
                j = 0;
                while (j < right.children.length) {
                    newChildren[xcl + j] = right.children[j];
                    newChildren[xcl + j].parent = x;
                    ++j;
                }
                x.children = newChildren;
            }
            this.debug("MergeRight Intermediate state:" + x);
            ComparableADT[] newParKeys = new ComparableADT[parTree.keys.length - 1];
            int j11 = 0;
            while (j11 < i - 1) {
                newParKeys[j11] = parTree.keys[j11];
                ++j11;
            }
            j11 = i + 1;
            while (j11 < parTree.keys.length) {
                newParKeys[j11 - 1] = parTree.keys[j11];
                ++j11;
            }
            parTree.keys = newParKeys;
            BTreeSort[] newParChildren = new BTreeSort[parTree.children.length - 1];
            j = 0;
            while (j <= i) {
                newParChildren[j] = parTree.children[j];
                ++j;
            }
            j = i + 2;
            while (j < parTree.children.length) {
                newParChildren[j - 1] = parTree.children[j];
                ++j;
            }
            parTree.children = newParChildren;
            this.debug("parTree before fix:" + parTree + "it's own parent =" + parTree.parent + "it's keys:" + parTree.keys);
            this.fixUnderflow(parTree);
        }
    }

    public ComparableADT successor(ComparableADT a) {
        BTreeSort.checkRep(this);
        BTreeSort inputTree = this.search(a);
        if (BTreeSort.isNullBTree(inputTree)) {
            throw new RuntimeException("Key entered does not exist in BTree.");
        }
        if (a.equals(this.maximum())) {
            return null;
        }
        int k = 0;
        int j = 0;
        while (j < inputTree.keys.length) {
            if (inputTree.keys[j].compareTo(a) == 0) {
                k = j;
                break;
            }
            ++j;
        }
        if (inputTree.children != null) {
            return inputTree.children[k + 1].minimum();
        }
        BTreeSort initial = inputTree;
        BTreeSort parentTree = inputTree.parent;
        while (!BTreeSort.isNullBTree(parentTree) && inputTree.equals(parentTree.children[parentTree.children.length])) {
            inputTree = parentTree;
            parentTree = parentTree.parent;
        }
        if (BTreeSort.isNullBTree(parentTree)) {
            if (!inputTree.equals(initial)) {
                return null;
            }
            int index = 0;
            int j2 = 0;
            while (j2 < initial.keys.length) {
                if (initial.keys[j2].compareTo(a) > 0) {
                    index = j2;
                    break;
                }
                ++j2;
            }
            return initial.keys[index];
        }
        int index = 0;
        int j3 = 0;
        while (j3 < parentTree.keys.length) {
            if (parentTree.keys[j3].compareTo(a) > 0) {
                index = j3;
                break;
            }
            ++j3;
        }
        return parentTree.keys[index];
    }

    public ComparableADT predecessor(ComparableADT a) {
        BTreeSort.checkRep(this);
        BTreeSort inputTree = this.search(a);
        if (BTreeSort.isNullBTree(inputTree)) {
            throw new RuntimeException("Key entered does not exist in BTree.");
        }
        if (a.equals(this.minimum())) {
            return null;
        }
        int k = 0;
        int j = 0;
        while (j < inputTree.keys.length) {
            if (inputTree.keys[j].compareTo(a) == 0) {
                k = j;
            }
            ++j;
        }
        if (inputTree.children != null) {
            return inputTree.children[k].maximum();
        }
        BTreeSort initial = inputTree;
        BTreeSort parentTree = inputTree.parent;
        while (!BTreeSort.isNullBTree(parentTree) && inputTree.equals(parentTree.children[0])) {
            inputTree = parentTree;
            parentTree = parentTree.parent;
        }
        if (BTreeSort.isNullBTree(parentTree)) {
            if (!inputTree.equals(initial)) {
                return null;
            }
            int index = 0;
            int j2 = 0;
            while (j2 < initial.keys.length) {
                if (initial.keys[j2].compareTo(a) < 0) {
                    index = j2;
                    break;
                }
                ++j2;
            }
            return initial.keys[index];
        }
        int index = 0;
        int j3 = 0;
        while (j3 < parentTree.keys.length) {
            if (parentTree.keys[j3].compareTo(a) < 0) {
                index = j3 - 1;
                break;
            }
            ++j3;
        }
        return parentTree.keys[index];
    }

    public ComparableADT minimum() {
        BTreeSort.checkRep(this);
        if (this.keys == null) {
            return null;
        }
        if (this.isLeaf()) {
            return this.keys[0];
        }
        return this.children[0].minimum();
    }

    public ComparableADT maximum() {
        BTreeSort.checkRep(this);
        if (this.keys == null) {
            return null;
        }
        if (this.isLeaf()) {
            return this.keys[this.keys.length - 1];
        }
        return this.children[this.keys.length].maximum();
    }

    public BTreeSort search(ComparableADT a) {
        return this.searchBTree(this, a);
    }

    /*
     * Unable to fully structure code
     */
    private BTreeSort searchBTree(BTreeSort tr, ComparableADT a) {
        BTreeSort.checkRep(tr);
        i = 0;
        if (tr.keys != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            ++i;
lbl6:
            // 2 sources

            ** while (i < tr.keys.length && a.compareTo((Object)tr.keys[i]) > 0)
        }
lbl7:
        // 1 sources

        if (i < tr.keys.length && a.compareTo(tr.keys[i]) == 0) {
            return tr;
        }
        if (tr.isLeaf()) {
            return null;
        }
        return this.searchBTree(tr.children[i], a);
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public SeqSort inOrderWalk() {
        return this.inOrderWalkBTree(this);
    }

    private SeqSort inOrderWalkBTree(BTreeSort tr) {
        SeqSort result = SeqSort.empty();
        if (!BTreeSort.isNullBTree(tr)) {
            int i = 0;
            while (i < tr.keys.length) {
                if (!tr.isLeaf()) {
                    result = SeqSort.catenate(result, this.inOrderWalkBTree(tr.children[i]));
                }
                result = SeqSort.append(result, tr.keys[i]);
                ++i;
            }
            if (!tr.isLeaf()) {
                result = SeqSort.catenate(result, this.inOrderWalkBTree(tr.children[tr.keys.length]));
            }
        }
        return result;
    }

    public String toString() {
        if (debug) {
            int i;
            StringBuffer result = new StringBuffer("(");
            if (this.keys != null) {
                i = 0;
                while (i < this.keys.length) {
                    result.append(this.keys[i].toString());
                    result.append(" ");
                    ++i;
                }
            }
            if (this.children != null) {
                i = 0;
                while (i < this.children.length) {
                    result.append(this.children[i].toString());
                    ++i;
                }
            }
            result.append(")");
            return result.toString();
        }
        return this.inOrderWalk().toString();
    }

    public SeqSort children() {
        BTreeSort.checkRep(this);
        SeqSort result = SeqSort.empty();
        if (this.children == null) {
            return result;
        }
        int i = 0;
        while (i < this.children.length) {
            result = SeqSort.append(result, this.children[i]);
            ++i;
        }
        return result;
    }

    public SeqSort keys() {
        BTreeSort.checkRep(this);
        SeqSort result = SeqSort.empty();
        int i = 0;
        while (i < this.keys.length) {
            result = SeqSort.append(result, this.keys[i]);
            ++i;
        }
        return result;
    }

    public boolean in(ComparableADT a) {
        BTreeSort t = this.searchBTree(this, a);
        return t != null;
    }

    public static BoolSort isNull(BTreeSort t) {
        return BoolSort.lit(t == null || t.keys == null);
    }

    public static boolean isNullBTree(BTreeSort t) {
        return t == null || t.keys == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BTreeSort)) {
            return false;
        }
        BTreeSort b = (BTreeSort)o;
        if (this == b) {
            return true;
        }
        return this.inOrderWalk().equals(b.inOrderWalk());
    }

    public int hashCode() {
        int sum = 0;
        if (this.keys == null) {
            return sum;
        }
        int i = 0;
        while (i < this.keys.length) {
            sum += this.keys[i].hashCode();
            ++i;
        }
        return sum;
    }

    private static void checkRep(BTreeSort tr) {
        if (!debug) {
            return;
        }
        if (tr == null) {
            return;
        }
        if (tr.keys == null && tr.children != null) {
            throw new RuntimeException("Representation Invariant Broken\nIn: " + tr + "keys = null, but children != null");
        }
        if (tr.keys != null && tr.keys.length == 0) {
            throw new RuntimeException("Representation Invariant Broken\nIn: " + tr + "keys field was empty (instead of null)");
        }
        if (tr.children != null && tr.children.length == 0) {
            throw new RuntimeException("Representation Invariant Broken\nIn: " + tr + "children field was empty (instead of null)");
        }
        if (tr.children != null) {
            int i = 0;
            while (i < tr.children.length) {
                if (tr.children[i].parent != tr) {
                    throw new RuntimeException("Representation Invariant Broken\nChild " + tr.children[i] + " does not point to parent " + tr + " but to " + tr.children[i].parent);
                }
                BTreeSort.checkRep(tr.children[i]);
                ++i;
            }
        }
        if (tr.children != null && tr.parent != null) {
            if (tr.children.length < 2 || tr.children.length > 4) {
                throw new RuntimeException("Representation Invariant broken\n: Node " + tr + " has " + tr.children.length + " children.");
            }
            if (tr.children.length != tr.keys.length + 1) {
                throw new RuntimeException("Representation Invariant broken\n: Node " + tr + " has " + tr.children.length + " children but " + tr.keys.length + " keys.");
            }
        }
    }

    private void debug(String message) {
        if (debug) {
            System.out.println(message);
        }
    }

    public static ADT construct(Parameterization p) {
        return BTreeSort.empty();
    }

    public SValue toSValue() {
        SList rep = new SList();
        rep.add((Object)this.keys().toSValue());
        rep.add((Object)this.children().toSValue());
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue value) {
        BTreeSort result = BTreeSort.empty();
        SList rep = (SList)value;
        SeqSort keySeq = (SeqSort)ADT.construct(rep.getSValue(0));
        int n_keys = (int)SeqSort.len((SeqSort)keySeq).value;
        if (n_keys > 0) {
            ComparableADT[] newKeys = new ComparableADT[n_keys];
            int i = 0;
            while (i < n_keys) {
                newKeys[i] = (ComparableADT)SeqSort.head(keySeq);
                keySeq = SeqSort.tail(keySeq);
                ++i;
            }
            result.keys = newKeys;
        }
        SeqSort childrenSeq = (SeqSort)ADT.construct(rep.getSValue(1));
        int n_children = (int)SeqSort.len((SeqSort)childrenSeq).value;
        if (n_children > 0) {
            BTreeSort[] newChildren = new BTreeSort[n_children];
            int i = 0;
            while (i < n_children) {
                newChildren[i] = (BTreeSort)SeqSort.head(childrenSeq);
                newChildren[i].parent = result;
                childrenSeq = SeqSort.tail(childrenSeq);
                ++i;
            }
            result.children = newChildren;
        }
        return result;
    }
}

