/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.ComparableADT;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.runtime.adt.SeqSort;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class BSTSort
extends ADT
implements Serializable,
Cloneable,
SPrintable {
    protected BSTSort left = null;
    protected BSTSort right = null;
    protected ComparableADT value;
    protected BSTSort parent;

    public BSTSort() {
        this.value = null;
        this.parent = null;
    }

    public BSTSort(ComparableADT a) {
        this.value = a;
        this.parent = null;
    }

    public static BSTSort empty() {
        return new BSTSort();
    }

    public static BSTSort singleton(ComparableADT a) {
        return new BSTSort(a);
    }

    public static BSTSort insert(ComparableADT a, BSTSort t) {
        if (t == null) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        if (t.value == null) {
            return new BSTSort(a);
        }
        return t.insert(a);
    }

    public static BSTSort delete(ComparableADT a, BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree. ");
        }
        return t.delete(a);
    }

    public static BoolSort isIn(ComparableADT a, BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(t.in(a));
    }

    public static BSTSort leftChild(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.left;
    }

    public static BSTSort rightChild(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.right;
    }

    public static BSTSort parent(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.parent;
    }

    public static BSTSort successor(ComparableADT a, BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.successor(a);
    }

    public static BSTSort predecessor(ComparableADT a, BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.predecessor(a);
    }

    public static BSTSort minimum(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.minimum();
    }

    public static BSTSort maximum(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.maximum();
    }

    public static ComparableADT root(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.value;
    }

    public static BSTSort search(ComparableADT a, BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.search(a);
    }

    public static BoolSort hasLeft(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(!BSTSort.isNull(t.left));
    }

    public static BoolSort hasRight(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(!BSTSort.isNull(t.right));
    }

    public static BoolSort isLeaf(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return BoolSort.lit(BSTSort.isNull(t.left) && BSTSort.isNull(t.right));
    }

    public static SeqSort preOrderWalk(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.preOrderWalk();
    }

    public static SeqSort inOrderWalk(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.inOrderWalk();
    }

    public static SeqSort postOrderWalk(BSTSort t) {
        if (BSTSort.isNull(t)) {
            throw new RepException("Inputted tree is null. Cannot perform operation on null tree.");
        }
        return t.postOrderWalk();
    }

    public Object clone() {
        BSTSort newTree = new BSTSort();
        newTree.value = this.value;
        newTree.parent = this.parent;
        newTree.left = this.left == null ? null : (BSTSort)this.left.clone();
        newTree.right = this.right == null ? null : (BSTSort)this.right.clone();
        return newTree;
    }

    public BSTSort insert(ComparableADT a) {
        BSTSort copyTree = (BSTSort)this.clone();
        BSTSort newParent = null;
        BSTSort currTree = copyTree;
        while (!BSTSort.isNull(currTree)) {
            newParent = currTree;
            currTree = a.compareTo(currTree.value) <= 0 ? currTree.left : currTree.right;
        }
        BSTSort newTree = new BSTSort(a);
        newTree.parent = newParent;
        if (!BSTSort.isNull(newParent)) {
            newTree.value = a;
        } else if (a.compareTo(newParent.value) <= 0) {
            newParent.left = newTree;
        } else {
            newParent.right = newTree;
        }
        return copyTree;
    }

    public BSTSort delete(ComparableADT a) {
        BSTSort newTree = (BSTSort)this.clone();
        BSTSort delTree = newTree.search(a);
        BSTSort spliceTree = null;
        if (delTree != null) {
            spliceTree = BSTSort.isNull(delTree.left) || BSTSort.isNull(delTree.right) ? delTree : newTree.successor(a);
            BSTSort childTree = !BSTSort.isNull(spliceTree.left) ? spliceTree.left : spliceTree.right;
            if (!BSTSort.isNull(childTree)) {
                childTree.parent = spliceTree.parent;
            }
            if (BSTSort.isNull(spliceTree.parent)) {
                newTree.value = childTree.value;
            } else if (spliceTree.equals(spliceTree.parent.left)) {
                spliceTree.parent.left = childTree;
            } else {
                spliceTree.parent.right = childTree;
            }
            if (!spliceTree.equals(delTree)) {
                delTree.value = spliceTree.value;
            }
        }
        return newTree;
    }

    private BSTSort successor(ComparableADT a) {
        BSTSort inputTree = this.search(a);
        if (BSTSort.isNull(inputTree)) {
            throw new RepException("Value entered does not exist in BST. Cannot find successor of non-existent value");
        }
        if (!BSTSort.isNull(inputTree.right)) {
            return inputTree.right.minimum();
        }
        BSTSort parentTree = inputTree.parent;
        while (!BSTSort.isNull(parentTree) && inputTree.equals(parentTree.right)) {
            inputTree = parentTree;
            parentTree = parentTree.parent;
        }
        return parentTree;
    }

    private BSTSort predecessor(ComparableADT a) {
        BSTSort inputTree = this.search(a);
        if (BSTSort.isNull(inputTree)) {
            throw new RepException("Value entered does not exist in BST. Cannot find predecessor of non-existent value");
        }
        if (!BSTSort.isNull(inputTree.left)) {
            return inputTree.left.maximum();
        }
        BSTSort parentTree = inputTree.parent;
        while (!BSTSort.isNull(parentTree) && inputTree.equals(parentTree.left)) {
            inputTree = parentTree;
            parentTree = parentTree.parent;
        }
        return parentTree;
    }

    private BSTSort minimum() {
        if (BSTSort.isNull(this.left)) {
            return this;
        }
        return this.left.minimum();
    }

    private BSTSort maximum() {
        if (BSTSort.isNull(this.right)) {
            return this;
        }
        return this.right.maximum();
    }

    private BSTSort search(ComparableADT a) {
        if (a.compareTo(this.value) == 0) {
            return this;
        }
        if (a.compareTo(this.value) < 0) {
            if (BSTSort.isNull(this.left)) {
                return null;
            }
            return this.left.search(a);
        }
        if (BSTSort.isNull(this.right)) {
            return null;
        }
        return this.right.search(a);
    }

    private SeqSort preOrderWalk() {
        SeqSort result = new SeqSort();
        result = SeqSort.append(result, this.value);
        if (!BSTSort.isNull(this.left)) {
            SeqSort leftResult = this.left.preOrderWalk();
            result = SeqSort.catenate(result, leftResult);
        }
        if (!BSTSort.isNull(this.right)) {
            SeqSort rightResult = this.right.preOrderWalk();
            result = SeqSort.catenate(result, rightResult);
        }
        return result;
    }

    private SeqSort postOrderWalk() {
        SeqSort result = new SeqSort();
        result = SeqSort.append(result, this.value);
        SeqSort leftResult = new SeqSort();
        SeqSort rightResult = new SeqSort();
        if (!BSTSort.isNull(this.left)) {
            leftResult = this.left.postOrderWalk();
        }
        if (!BSTSort.isNull(this.right)) {
            rightResult = this.right.postOrderWalk();
        }
        rightResult = SeqSort.catenate(leftResult, rightResult);
        result = SeqSort.catenate(rightResult, result);
        return result;
    }

    public SeqSort inOrderWalk() {
        SeqSort result = new SeqSort();
        result = SeqSort.append(result, this.value);
        SeqSort leftResult = new SeqSort();
        SeqSort rightResult = new SeqSort();
        if (!BSTSort.isNull(this.left)) {
            leftResult = this.left.inOrderWalk();
        }
        if (!BSTSort.isNull(this.right)) {
            rightResult = this.right.inOrderWalk();
        }
        result = SeqSort.catenate(leftResult, result);
        result = SeqSort.catenate(result, rightResult);
        return result;
    }

    public String toString() {
        String result = "";
        if (!BSTSort.isNull(this.left)) {
            result = String.valueOf(result) + this.left.toString();
        }
        result = String.valueOf(result) + this.value.toString();
        if (!BSTSort.isNull(this.right)) {
            result = String.valueOf(result) + this.right.toString();
        }
        return result;
    }

    public static ADT construct(Parameterization p) {
        return BSTSort.empty();
    }

    private boolean in(ComparableADT a) {
        if (a.compareTo(this.value) == 0) {
            return true;
        }
        if (a.compareTo(this.value) < 0) {
            if (BSTSort.isNull(this.left)) {
                return false;
            }
            return this.left.in(a);
        }
        if (BSTSort.isNull(this.right)) {
            return false;
        }
        return this.right.in(a);
    }

    public static boolean isNull(BSTSort t) {
        return t == null || t.value == null;
    }

    public boolean equals(Object o) {
        if (o instanceof BSTSort) {
            BSTSort b = (BSTSort)o;
            if (this == b) {
                return true;
            }
            if (BSTSort.isNull(this) || BSTSort.isNull(b)) {
                return false;
            }
            if (!this.value.equals(b.value)) {
                return false;
            }
            boolean leftEqual = false;
            boolean rightEqual = false;
            if (BSTSort.isNull(this.left)) {
                if (BSTSort.isNull(b.left)) {
                    leftEqual = true;
                } else if (!BSTSort.isNull(b.left)) {
                    leftEqual = this.left.equals(b.left);
                }
            }
            if (BSTSort.isNull(this.right)) {
                if (BSTSort.isNull(b.right)) {
                    rightEqual = true;
                } else if (!BSTSort.isNull(b.right)) {
                    rightEqual = this.right.equals(b.right);
                }
            }
            return leftEqual && rightEqual;
        }
        return false;
    }

    public int hashCode() {
        int sum = 0;
        sum = this.value.hashCode() + this.left.hashCode() + this.right.hashCode();
        return sum;
    }

    public SValue toSValue() {
        SList rep = new SList();
        rep.add((Object)this.left.toSValue());
        rep.add((Object)this.value.toSValue());
        rep.add((Object)this.right.toSValue());
        rep.add((Object)this.parent.toSValue());
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue value) {
        BSTSort tree = BSTSort.empty();
        SList rep = (SList)value;
        ADT newLeft = ADT.construct(rep.getSValue(0));
        ADT newVal = ADT.construct(rep.getSValue(1));
        ADT newRight = ADT.construct(rep.getSValue(2));
        ADT newParent = ADT.construct(rep.getSValue(3));
        tree.left = (BSTSort)newLeft;
        tree.value = (ComparableADT)newVal;
        tree.right = (BSTSort)newRight;
        tree.parent = (BSTSort)newParent;
        return tree;
    }
}

