/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.Number;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RealSort;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;

public class AugmentedRealSort
extends Number
implements Serializable {
    private static final long serialVersionUID = 6415766892297046880L;

    public static Entity construct() {
        return new AugmentedRealSort(3.145);
    }

    public static ADT construct(Parameterization p) {
        return new AugmentedRealSort(3.145);
    }

    protected AugmentedRealSort(double value) {
        this.value = value;
    }

    public static AugmentedRealSort lit(double value) {
        return new AugmentedRealSort(value);
    }

    public static AugmentedRealSort infty() {
        return new AugmentedRealSort(Number.POS_INFTY);
    }

    public static AugmentedRealSort real2augmented(RealSort r) {
        return new AugmentedRealSort(r.value);
    }

    public static RealSort augmented2real(AugmentedRealSort r) {
        if (r.value == Number.POS_INFTY) {
            throw new RuntimeException("Error: Attempted to assign Infinity to a Real variable");
        }
        return new RealSort(r.value);
    }

    public static ADT construct(SValue svalue) {
        return new AugmentedRealSort(Double.valueOf(svalue.toString()));
    }

    public static ADT construct(Double d) {
        return new AugmentedRealSort(d);
    }

    public static AugmentedRealSort neg(Number n) {
        return AugmentedRealSort.lit(-n.value);
    }

    public static AugmentedRealSort abs(Number n) {
        return AugmentedRealSort.lit(Math.abs(n.value));
    }

    public static AugmentedRealSort pred(Number n) {
        return AugmentedRealSort.lit(n.value - 1.0);
    }

    public static AugmentedRealSort succ(Number n) {
        return AugmentedRealSort.lit(n.value + 1.0);
    }

    public static AugmentedRealSort add(Number n1, Number n2) {
        return AugmentedRealSort.lit(n1.value + n2.value);
    }

    public static AugmentedRealSort sub(Number n1, Number n2) {
        return AugmentedRealSort.lit(n1.value - n2.value);
    }

    public static AugmentedRealSort mul(Number n1, Number n2) {
        return AugmentedRealSort.lit(n1.value * n2.value);
    }

    public static AugmentedRealSort power(Number n1, Number n2) {
        return AugmentedRealSort.lit(Math.pow(n1.value, n2.value));
    }

    public static AugmentedRealSort div(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't divide by zero.");
        }
        return AugmentedRealSort.lit(n1.value / n2.value);
    }

    public static AugmentedRealSort mod(Number n1, Number n2) {
        if (n2.value == 0.0) {
            throw new RepException("IntSort: Can't mod by zero.");
        }
        return AugmentedRealSort.lit(n1.value % n2.value);
    }

    public static AugmentedRealSort min(Number n1, Number n2) {
        return AugmentedRealSort.lit(Math.min(n1.value, n2.value));
    }

    public static AugmentedRealSort max(Number n1, Number n2) {
        return AugmentedRealSort.lit(Math.max(n1.value, n2.value));
    }
}

