/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.IndexSeq;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.runtime.adt.RepException;
import com.veromodo.tioa.util.ToStringComparator;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ArraySort
extends ADT
implements Cloneable,
Serializable {
    protected Hashtable table = new Hashtable();
    protected Object constantValue = null;
    protected boolean hasConstantValue = false;

    public static ArraySort constant(ADT constant) {
        return new ArraySort(constant);
    }

    public static Object elementAt(ArraySort array, Object index) {
        return array.elementAt(new IndexSeq(new Object[]{index}));
    }

    public static ArraySort assign(ArraySort array, Object index, Object value) {
        return array.assign(new IndexSeq(new Object[]{index}), value);
    }

    public static Object elementAt(ArraySort array, Object index1, Object index2) {
        return array.elementAt(new IndexSeq(new Object[]{index1, index2}));
    }

    public static ArraySort assign(ArraySort array, Object index1, Object index2, Object value) {
        return array.assign(new IndexSeq(new Object[]{index1, index2}), value);
    }

    public static Object elementAt(Object[] args) {
        ArraySort arraySort = (ArraySort)args[0];
        Object[] index = new Object[args.length - 1];
        int i = 1;
        while (i < args.length) {
            index[i - 1] = args[i];
            ++i;
        }
        return arraySort.elementAt(new IndexSeq(index));
    }

    public static ArraySort assign(Object[] args) {
        ArraySort arraySort = (ArraySort)args[0];
        Object rangeValue = args[args.length - 1];
        Object[] domainValues = new Object[args.length - 2];
        int i = 1;
        while (i < args.length - 1) {
            domainValues[i - 1] = args[i];
            ++i;
        }
        return arraySort.assign(new IndexSeq(domainValues), rangeValue);
    }

    public ArraySort(Object constant) {
        this.constantValue = constant;
        this.hasConstantValue = true;
    }

    public static ADT construct(Parameterization p) {
        return ArraySort.constant(p.constructSubsort(p.nSubsorts() - 1));
    }

    public Object elementAt(IndexSeq indexSeq) {
        Object value = this.table.get(indexSeq);
        if (value == null) {
            if (this.hasConstantValue) {
                return this.constantValue;
            }
            throw new RepException("tioa.runtime.adt.ArraySort: attempt to access undefined array element.");
        }
        return value;
    }

    public int size() {
        return this.table.size();
    }

    public Enumeration enumElements() {
        return this.table.elements();
    }

    public Enumeration enumIndices() {
        return this.table.keys();
    }

    public Map getMap() {
        return Collections.unmodifiableMap(new HashMap(this.table));
    }

    public String toString() {
        String s = "(ArraySort";
        s = this.hasConstantValue ? String.valueOf(s) + " (ConstantValue " + this.constantValue + ")" : String.valueOf(s) + " (ConstantValue <none>)";
        TreeMap tm = new TreeMap(new ToStringComparator());
        tm.putAll(this.table);
        Iterator i = tm.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            IndexSeq key = (IndexSeq)i.next();
            Object value = this.elementAt(key);
            sb.append(" (" + key + " " + value + ")");
        }
        s = String.valueOf(s) + sb.toString();
        s = String.valueOf(s) + ")";
        return s;
    }

    public boolean equals(Object object) {
        IndexSeq index;
        if (!(object instanceof ArraySort)) {
            return false;
        }
        ArraySort array = (ArraySort)object;
        if (array.hasConstantValue != this.hasConstantValue) {
            return false;
        }
        if (this.hasConstantValue && !array.constantValue.equals(this.constantValue)) {
            return false;
        }
        Enumeration enum1 = array.enumIndices();
        while (enum1.hasMoreElements()) {
            index = (IndexSeq)enum1.nextElement();
            if (array.elementAt(index).equals(this.elementAt(index))) continue;
            return false;
        }
        enum1 = this.enumIndices();
        while (enum1.hasMoreElements()) {
            index = (IndexSeq)enum1.nextElement();
            if (this.elementAt(index).equals(array.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        ArraySort copy = new ArraySort(this.constantValue);
        copy.table = (Hashtable)this.table.clone();
        copy.hasConstantValue = this.hasConstantValue;
        return copy;
    }

    public ArraySort assign(IndexSeq indexSeq, Object value) {
        ArraySort result = (ArraySort)this.clone();
        result.table.put(indexSeq, value);
        return result;
    }

    public SValue toSValue() {
        SList rep = new SList();
        rep.add((Object)((ADT)this.constantValue).toSValue());
        SList elements = new SList();
        rep.add((Object)elements);
        TreeSet ts = new TreeSet(new ToStringComparator());
        ts.addAll(this.table.keySet());
        for (Object key : ts) {
            SList entry = new SList();
            entry.add((Object)((IndexSeq)key).toSValue());
            ADT value = (ADT)this.table.get(key);
            entry.add((Object)value.toSValue());
            elements.add((Object)entry);
        }
        return this.toSValue((SValue)rep);
    }

    public static ADT construct(SValue svalue) {
        SList list = (SList)svalue;
        ADT constantValue = ADT.construct(list.getSValue(0));
        ArraySort array = ArraySort.constant(constantValue);
        SList elements = (SList)list.getSValue(1);
        for (SList entry : elements) {
            IndexSeq indexSeq = new IndexSeq(entry.getSValue(0));
            ADT value = ADT.construct(entry.getSValue(1));
            array.table.put(indexSeq, value);
        }
        return array;
    }
}

