/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime.adt;

import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.NotEnumerableException;
import com.veromodo.tioa.runtime.adt.Parameterization;
import com.veromodo.tioa.simulator.Entity;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public abstract class ADT
implements Entity,
SPrintable {
    private static final IOACategory debug = IOACategory.getInstance((String)ADT.class.getName());
    private Set getElementsCached = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String toString() {
        return this.getClass().getName();
    }

    public String traceChange(ADT t2) {
        return t2.toString();
    }

    public boolean booleanValue() {
        throw new Error("ADT subclass did not override booleanValue()");
    }

    public static Entity construct() {
        throw new Error("Should call construct(Parameterization) instead");
    }

    public static Entity construct(int n) {
        throw new Error("Attempted construction from int on non-int sort");
    }

    public static ADT construct(Parameterization p) {
        throw new Error("ADT subclass did not override construct(Parameterization)");
    }

    public static BoolSort equals(ADT adt1, ADT adt2) {
        return BoolSort.lit(adt1.equals(adt2));
    }

    public static BoolSort notEquals(ADT adt1, ADT adt2) {
        return BoolSort.lit(!adt1.equals(adt2));
    }

    public static ADT ifThenElse(BoolSort predicate, ADT ifResult, ADT elseResult) {
        return predicate.equals(BoolSort.True()) ? ifResult : elseResult;
    }

    public abstract SValue toSValue();

    public SValue toSValue(SValue adtRep) {
        return SExp.makeSList((SValue)SExp.makeSValue((String)this.getClass().getName()), (SValue)adtRep);
    }

    public static ADT construct(SValue svalue) {
        try {
            SList list = (SList)svalue;
            Class<?> adtClass = Class.forName(list.getSValue(0).toString());
            Method method = adtClass.getDeclaredMethod("construct", SValue.class);
            SValue rest = list.getSValue(1);
            Object object = method.invoke(null, rest);
            return (ADT)object;
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
            throw new RuntimeException(ite.getTargetException().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getClass() + ": " + e.getMessage());
        }
    }

    public Set getElements() throws NotEnumerableException {
        if (this.getElementsCached == null) {
            this.getElementsCached = this.getElementsImpl();
            if (debug.isDebugEnabled()) {
                debug.debug((Object)("Having to use non cached value for " + this.getClass().getName()));
                debug.debug((Object)("  result: " + this.getElementsCached));
            }
        }
        return this.getElementsCached;
    }

    protected Set getElementsImpl() throws NotEnumerableException {
        throw new NotEnumerableException(this);
    }

    public boolean isEnumerable() {
        return false;
    }
}

