/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.runtime;

import com.veromodo.tioa.runtime.adt.ADT;
import com.veromodo.tioa.runtime.adt.BoolSort;
import com.veromodo.tioa.runtime.adt.HandleSort;
import com.veromodo.tioa.runtime.adt.MPINode;
import com.veromodo.tioa.runtime.adt.SeqSort;
import com.veromodo.tioa.runtime.io.Debugger;
import com.veromodo.tioa.runtime.io.RoundRobinScheduler;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SParseException;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import mpi.MPI;
import mpi.MPIException;
import mpi.Status;

public abstract class Automaton
implements Runnable {
    protected static final boolean useMPI = true;
    protected static final int mpiTag = 20;
    protected static SeqSort stdin;
    protected static SeqSort stdout;
    private static SList formals;
    SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private static String stdInFilename;
    protected Map variables = new HashMap();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) throws MPIException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Debugger.debug = false;
        formals = null;
        int argNumber = 0;
        while (argNumber < args.length) {
            String arg = args[argNumber];
            if (!arg.equals("-big")) {
                if (arg.equals("-debug")) {
                    Debugger.debug = true;
                } else if (arg.equals("-formals")) {
                    if (args.length == argNumber - 1) {
                        throw new RuntimeException("-formals must be followed by a file prefix");
                    }
                    SParser parser = new SParser();
                    try {
                        String fileName = String.valueOf(args[argNumber + 1]) + "." + MPI.COMM_WORLD.Rank();
                        BufferedReader read = new BufferedReader(new FileReader(fileName));
                        formals = (SList)parser.parse((Reader)read);
                    }
                    catch (SParseException e) {
                        throw new RuntimeException("Error unparsing formal parameter initialization");
                    }
                } else if (arg.equals("-stdIn")) {
                    if (args.length == argNumber - 1) {
                        throw new RuntimeException("-stdIn must be followed by a file prefix");
                    }
                    stdInFilename = args[argNumber + 1];
                }
            }
            ++argNumber;
        }
        String subclassName = args[0];
        int nMPIArgs = args.length - argNumber;
        String[] MPIArgs = new String[nMPIArgs];
        int i = 0;
        while (argNumber < args.length) {
            MPIArgs[i] = args[argNumber];
            ++argNumber;
            ++i;
        }
        stdin = SeqSort.empty();
        stdout = SeqSort.empty();
        Debugger.msg("Automaton::starting MPI");
        int rank = MPI.COMM_WORLD.Rank();
        int size = MPI.COMM_WORLD.Size();
        String hostName = MPI.Get_processor_name();
        Debugger.msg("Automaton::Node: " + rank + " of " + size + " on " + hostName + ".");
        RoundRobinScheduler scheduler = new RoundRobinScheduler(1);
        Class<?> mainThreadClass = Class.forName(subclassName);
        Runnable runnable = (Runnable)mainThreadClass.newInstance();
        Thread mainThread = new Thread(runnable, subclassName);
        mainThread.run();
        MPI.Finalize();
    }

    public void initializeFormals() {
        if (formals == null) {
            return;
        }
        for (SList next : formals) {
            String paramName = next.get(0).toString();
            String sortName = next.get(1).toString();
            Object value = next.get(2);
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    String name = fields[i].getName();
                    if (name.indexOf("_") != -1) {
                        name = name.substring(0, name.lastIndexOf(95));
                        String type = fields[i].getType().getName();
                        if (name.equals(paramName) && type.equals(sortName)) {
                            Class<?> realClass = Class.forName(sortName);
                            Class[] partypes = new Class[]{SValue.class};
                            Method constrMethod = realClass.getMethod("construct", partypes);
                            Object[] arglist = new Object[]{value};
                            Object realValue = constrMethod.invoke((Object)this, arglist);
                            fields[i].set(this, realValue);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in initializing formal parameters");
                }
                ++i;
            }
        }
    }

    public static SeqSort getStdin() {
        return stdin;
    }

    public static SeqSort getStdout() {
        return stdout;
    }

    public static void setStdin(SeqSort stdin) {
        Automaton.stdin = stdin;
    }

    public static void setStdout(SeqSort stdout) {
        Automaton.stdout = stdout;
    }

    public void run() {
        this.initializeFormals();
        this.traceInitialStates();
        try {
            this.schedule();
        }
        catch (MPIException e) {
            throw new RuntimeException(e);
        }
    }

    protected void schedule() throws MPIException {
        throw new RuntimeException("Tried to run an automaton with no schedule.");
    }

    protected static SeqSort testMPI(HandleSort handle, SeqSort handleQ, SeqSort sentQ) throws MPIException {
        if (handle.asRequest().Test() == null) {
            return handleQ;
        }
        sentQ = SeqSort.tail(sentQ);
        return SeqSort.tail(handleQ);
    }

    protected static SeqSort sendMPI(ADT msg, MPINode dest, SeqSort handleQ) throws MPIException {
        Object[] buffer = new Object[]{msg};
        HandleSort handle = new HandleSort(MPI.COMM_WORLD.Isend((Object)buffer, 0, 1, MPI.OBJECT, dest.asRank(), 20));
        return SeqSort.append(handleQ, handle);
    }

    protected static SeqSort recvMPI(MPINode source, SeqSort receiveQ) throws MPIException {
        Object[] buffer = new Object[1];
        Status status = MPI.COMM_WORLD.Recv((Object)buffer, 0, 1, MPI.OBJECT, source.asRank(), 20);
        return SeqSort.append(receiveQ, (ADT)buffer[0]);
    }

    protected static BoolSort probeMPI(MPINode source) throws MPIException {
        Status status = MPI.COMM_WORLD.Iprobe(source.asRank(), 20);
        return status == null ? BoolSort.False() : BoolSort.True();
    }

    protected Map getStatesMap() {
        HashMap<String, ADT> map = new HashMap<String, ADT>();
        Field[] fields = this.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            try {
                String name = fields[i].getName();
                if (name.indexOf("_") != -1) {
                    name = name.substring(0, name.lastIndexOf(95));
                    ADT value = (ADT)fields[i].get(this);
                    map.put(name, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't access field " + fields[i]);
            }
            ++i;
        }
        return map;
    }

    protected Map changesMap(Map oldMap, Map newMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : newMap.keySet()) {
            ADT newValue = (ADT)newMap.get(key);
            ADT oldValue = (ADT)oldMap.get(key);
            if (oldValue == null || newValue == null) {
                result.put(key, newValue == null ? "null" : newValue.toString());
                continue;
            }
            if (oldValue.equals(newValue)) continue;
            result.put(key, oldValue.traceChange(newValue));
        }
        return result;
    }

    protected void traceVariables(Map map) {
        TreeSet keySet = new TreeSet(map.keySet());
        Iterator keys = keySet.iterator();
        if (keys.hasNext()) {
            this.trace("%%%% Modified state variables:");
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.trace("     " + key + " --> " + map.get(key));
        }
    }

    public String timeNow() {
        return this.formatter.format(new Date());
    }

    protected void traceInitialStates() {
        try {
            this.trace("[[[[ Initialization starts (" + MPI.COMM_WORLD.Rank() + ") on " + MPI.Get_processor_name() + " at " + this.timeNow());
        }
        catch (MPIException e) {
            this.trace("[[[[ Initialization starts [[[[");
        }
        this.traceVariables(this.getStatesMap());
        this.trace("]]]] Initialization ends]]]]");
    }

    protected void trace(String message) {
        System.out.println(message);
    }

    protected void enteredTransition(String transition) {
        try {
            this.trace("[[[[ transition: " + transition + "(" + MPI.COMM_WORLD.Rank() + ") \n on " + MPI.Get_processor_name() + " at " + this.timeNow());
        }
        catch (MPIException e) {
            this.trace("[[[[ transition: " + transition);
        }
    }

    protected void exitedTransition(String transition) {
        Map newVariables = this.getStatesMap();
        Map diff = this.changesMap(this.variables, newVariables);
        this.traceVariables(diff);
        this.variables = newVariables;
        this.trace("]]]]");
    }

    protected void assertPrecondition(boolean predicate) {
        if (!predicate) {
            throw new RuntimeException("fired transition with false precondition");
        }
    }

    protected void assertWhereClause(boolean predicate) {
        if (!predicate) {
            throw new RuntimeException("fired transition with false where clause");
        }
    }
}

