/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry.java;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicOperator;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.DynamicImplRegistry;
import com.veromodo.tioa.registry.DynamicRegistrable;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.registry.Installer;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.logger.IOACategory;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;

public class UnionSort
implements DynamicRegistrable {
    public static final String className = "UnionSort";
    protected static final IOACategory cat = IOACategory.getInstance((String)"tioa.registry.java.UnionSort");

    public void install(ConstrImplRegistry reg) throws RegistryException {
        if (!(reg instanceof DynamicImplRegistry)) {
            throw new RegistryException("This is a dynamic registrable class and requires a DynamicImplRegistry");
        }
        ((DynamicImplRegistry)reg).addDynRegistrable(new UnionSort());
    }

    public boolean isDynamic(Sort sort) {
        return sort.isUnion();
    }

    public void installDynamic(DynamicImplRegistry reg, Sort sort) throws RegistryException {
        String fieldName;
        String sortName = sort.getName();
        Installer installer = ImplFactory.getInstance().newInstaller(className, reg);
        installer.addSort(sortName);
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("installing union " + sortName + " with fields " + sort.getFieldNames().toString()));
        }
        Iterator i = sort.getFieldNames().iterator();
        Iterator j = sort.getFieldSorts().iterator();
        String fieldNamesString = "";
        while (i.hasNext()) {
            fieldName = (String)i.next();
            String fieldSortName = ((Sort)j.next()).getName();
            fieldNamesString = String.valueOf(fieldNamesString) + fieldName + "%";
        }
        fieldNamesString = fieldNamesString.trim();
        i = sort.getFieldNames().iterator();
        j = sort.getFieldSorts().iterator();
        while (i.hasNext()) {
            BasicOperator stubOperator;
            fieldName = (String)i.next();
            Sort fieldSort = (Sort)j.next();
            String fieldSortName = fieldSort.getName();
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("installing " + sortName + "." + fieldName + " : " + fieldSortName));
            }
            Vector<String> builtIns = new Vector<String>();
            builtIns.add(fieldName);
            Vector<Sort> lookupFieldSorts = new Vector<Sort>();
            lookupFieldSorts.add(sort);
            try {
                stubOperator = new BasicOperator("", 5, fieldName, "", lookupFieldSorts, fieldSort, false, null);
            }
            catch (ILException e) {
                throw new RegistryException("Error in stub operator creation");
            }
            installer.addCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "lookupField", builtIns, false);
            builtIns = new Vector();
            builtIns.add(fieldNamesString);
            builtIns.add(fieldName);
            Vector<Sort> makeFieldSorts = new Vector<Sort>();
            makeFieldSorts.add(fieldSort);
            try {
                stubOperator = new BasicOperator("", 0, fieldName, "", makeFieldSorts, sort, false, null);
            }
            catch (ILException e) {
                throw new RegistryException("Error in stub operator creation");
            }
            installer.addCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "make", builtIns, false);
        }
        Assert.assertTrue(sort.getUnionTagSort().isEnum(), "Sort of union tag must be an enumeration");
        Object[] args = new Object[]{sort.getName(), sort.getUnionTagSort().getName()};
        String template = MessageFormat.format("(tag ({0}) {1})", args);
        installer.addOp(template, "getTag");
    }
}

