/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry.java;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicOperator;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.DynamicImplRegistry;
import com.veromodo.tioa.registry.DynamicRegistrable;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.registry.Installer;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortTemplate;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Iterator;
import java.util.Vector;

public class TupleSort
implements DynamicRegistrable {
    protected static final IOACategory cat = IOACategory.getInstance((String)"tioa.registry.java.TupleSort");
    public static final String className = "TupleSort";

    public void install(ConstrImplRegistry reg) throws RegistryException {
        if (!(reg instanceof DynamicImplRegistry)) {
            throw new RegistryException("This is a dynamic registrable class and requires a DynamicImplRegistry");
        }
        ((DynamicImplRegistry)reg).addDynRegistrable(new TupleSort());
    }

    public boolean isDynamic(Sort sort) {
        return sort.isTuple();
    }

    public void installDynamic(DynamicImplRegistry reg, Sort sort) throws RegistryException {
        String template = new SortTemplate(sort).toString();
        Installer installer = ImplFactory.getInstance().newInstaller(className, reg);
        installer.addSort(template);
        cat.debug((Object)("installing tuple " + template + " with fields " + sort.getFieldNames().toString()));
        Iterator i = sort.getFieldNames().iterator();
        Iterator j = sort.getFieldSorts().iterator();
        Vector<Sort> fieldSorts = new Vector<Sort>();
        Vector<String> fieldNames = new Vector<String>();
        String fieldNamesString = "";
        while (i.hasNext()) {
            BasicOperator stubOperator;
            String fieldName = (String)i.next();
            Sort fieldSort = (Sort)j.next();
            cat.debug((Object)("Field sort: " + fieldSort.getKey()));
            Vector<String> builtIns = new Vector<String>();
            builtIns.add(fieldName);
            fieldNamesString = String.valueOf(fieldNamesString) + fieldName + "%";
            fieldSorts.add(fieldSort);
            cat.debug((Object)("installing " + template + "." + fieldName + " : " + fieldSort.getKey()));
            Vector<Sort> lookupFieldSorts = new Vector<Sort>();
            lookupFieldSorts.add(sort);
            try {
                stubOperator = new BasicOperator("", 5, fieldName, "", lookupFieldSorts, fieldSort, false, null);
            }
            catch (ILException e) {
                throw new RegistryException("Error in stub operator creation");
            }
            OpTemplate opTempl = new OpTemplate((Operator)stubOperator);
            String opTemplateString = opTempl.toString();
            installer.addAssignableCurriedOp(opTemplateString, "lookupField", "setField", builtIns, false);
            Vector<Sort> setFieldSorts = new Vector<Sort>();
            setFieldSorts.add(sort);
            setFieldSorts.add(fieldSort);
            try {
                stubOperator = new BasicOperator("", 0, "set_" + fieldName, "", setFieldSorts, sort, false, null);
            }
            catch (ILException e) {
                throw new RegistryException("Error in stub operator creation");
            }
            installer.addCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "setField", builtIns, false);
            fieldNamesString = fieldNamesString.trim();
            fieldNames = new Vector();
            fieldNames.add(fieldNamesString);
            try {
                stubOperator = new BasicOperator("", 4, "[", "]", fieldSorts, sort, false, null);
            }
            catch (ILException e) {
                throw new RegistryException("Error in stub operator creation");
            }
            installer.addCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "make", fieldNames, true);
        }
    }
}

