/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry.java;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicOperator;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.DynamicImplRegistry;
import com.veromodo.tioa.registry.DynamicRegistrable;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.registry.Installer;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortTemplate;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Vector;

public class MappSort
implements DynamicRegistrable {
    protected static final IOACategory cat = IOACategory.getInstance((String)"tioa.registry.java.MappSort");
    public static final String sortName = "Mapp";
    public static final String className = "MappSort";

    public void install(ConstrImplRegistry reg) throws RegistryException {
        if (!(reg instanceof DynamicImplRegistry)) {
            throw new RegistryException("This is a dynamic registrable class and requires a DynamicImplRegistry");
        }
        ((DynamicImplRegistry)reg).addDynRegistrable(new MappSort());
    }

    public boolean isDynamic(Sort sort) {
        Vector subsorts = sort.getSubsorts();
        String name = sort.getName();
        return name != null && name.equals(sortName) && subsorts != null && subsorts.size() > 0;
    }

    public void installDynamic(DynamicImplRegistry reg, Sort sort) throws RegistryException {
        BasicOperator stubOperator;
        String template = new SortTemplate(sort).toString();
        Installer installer = ImplFactory.getInstance().newInstaller(className, reg);
        installer.addSort(template);
        cat.debug((Object)("installing empty() for " + template));
        installer.addOp("(empty () %me)", "empty");
        cat.debug((Object)("installing minValue(MappSort) for " + template));
        installer.addOp("(minValue (%me) 0)", "minValue");
        cat.debug((Object)("installing update(" + template + ",__,...,__)"));
        Sort rangeSort = sort;
        Vector domainSorts = (Vector)sort.getSubsorts().clone();
        domainSorts.insertElementAt(sort, 0);
        try {
            stubOperator = new BasicOperator("", 0, "update", "", domainSorts, rangeSort, false, null);
        }
        catch (ILException e) {
            throw new RegistryException("Error in stub operator creation");
        }
        String opTemplString = new OpTemplate((Operator)stubOperator).toString();
        cat.debug((Object)opTemplString);
        installer.addCurriedOp(opTemplString, "update", new Vector(), true);
        cat.debug((Object)("installing defined(" + template + ",__,...)"));
        try {
            rangeSort = installer.sortNameToSort("Bool");
        }
        catch (ILException e) {
            throw new RegistryException("Error creating Bool sort" + (Object)((Object)e));
        }
        domainSorts = (Vector)sort.getSubsorts().clone();
        domainSorts.removeElementAt(domainSorts.size() - 1);
        domainSorts.insertElementAt(sort, 0);
        try {
            stubOperator = new BasicOperator("", 0, "defined", "", domainSorts, rangeSort, false, null);
        }
        catch (ILException e) {
            throw new RegistryException("Error in stub operator creation");
        }
        opTemplString = new OpTemplate((Operator)stubOperator).toString();
        cat.debug((Object)opTemplString);
        installer.addCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "defined", new Vector(), true);
        cat.debug((Object)("installing " + template + "[__,...]"));
        rangeSort = (Sort)sort.getSubsorts().lastElement();
        domainSorts = (Vector)sort.getSubsorts().clone();
        domainSorts.removeElementAt(domainSorts.size() - 1);
        domainSorts.insertElementAt(sort, 0);
        try {
            stubOperator = new BasicOperator("", 68, "[", "]", domainSorts, rangeSort, false, null);
        }
        catch (ILException e) {
            throw new RegistryException("Error in stub operator creation");
        }
        installer.addAssignableCurriedOp(new OpTemplate((Operator)stubOperator).toString(), "get", "update", new Vector(), true);
    }
}

