/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.Environment;
import com.veromodo.tioa.registry.InvalidTemplateException;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SParseException;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SValueException;
import java.util.Iterator;

public class SortTemplate {
    static final IOACategory cat = IOACategory.getInstance((String)SortTemplate.class.getName());
    protected SValue value;
    static /* synthetic */ Class class$0;

    public SortTemplate(String template) throws InvalidTemplateException {
        try {
            SParser parser = new SParser();
            this.value = parser.parse(template);
            this.unwrapIfNoSubsorts();
            cat.debug((Object)("constructed: " + this.value));
        }
        catch (SParseException e) {
            throw new InvalidTemplateException("template not an s-expression", (Exception)((Object)e));
        }
    }

    public SortTemplate(SValue parsedTemplate) {
        this.value = parsedTemplate;
        this.unwrapIfNoSubsorts();
        cat.debug((Object)("constructed: " + this.value));
    }

    protected void unwrapIfNoSubsorts() {
        if (this.isCompound() && this.list().size() == 1) {
            this.value = this.list().getSValue(0);
        }
    }

    public SortTemplate(Sort sort) {
        SValue name = SExp.makeSValue((String)sort.getName());
        Iterator iter = sort.getSubsorts().iterator();
        if (!iter.hasNext()) {
            this.value = name;
        } else {
            this.value = SExp.makeSList((SValue)name);
            while (iter.hasNext()) {
                SortTemplate subsort = new SortTemplate((Sort)iter.next());
                this.list().add((Object)subsort.toSexp());
            }
        }
        cat.debug((Object)("constructed: " + this.value));
    }

    public boolean isCompound() {
        return this.value instanceof SList;
    }

    public boolean isVariable() {
        return this.value instanceof SNumber;
    }

    public boolean isSimple() {
        return this.value instanceof SString;
    }

    public boolean canUnify(SortTemplate template, Environment env) {
        return this.canUnify(template.value, env);
    }

    protected boolean canUnify(SValue sexp, Environment env) {
        if (this.isVariable()) {
            SortTemplate template = new SortTemplate(sexp);
            if (template.isVariable()) {
                throw new RuntimeException("Variable-variable unification is not supported at this time.");
            }
            return template.canUnify(this.value, env);
        }
        if (sexp instanceof SString) {
            return this.canUnify((SString)sexp, env);
        }
        if (sexp instanceof SNumber) {
            return this.canUnify((SNumber)sexp, env);
        }
        if (sexp instanceof SList) {
            return this.canUnify((SList)sexp, env);
        }
        throw new RuntimeException("Unknown SValue type: " + sexp.getClass());
    }

    protected boolean canUnify(SString simpleName, Environment env) {
        cat.debug((Object)("canUnify: " + this.toString() + " with simple name " + simpleName));
        return this.isSimple() && this.value.equals((Object)simpleName);
    }

    protected boolean canUnify(SNumber sortVariable, Environment env) {
        cat.debug((Object)("canUnify: " + this.toString() + " with sort variable " + sortVariable));
        if (env.isBound(sortVariable)) {
            cat.debug((Object)("checking binding of " + sortVariable));
            return this.canUnify(env.lookup(sortVariable), env);
        }
        env.bind(sortVariable, new SortTemplate(this.value));
        return true;
    }

    protected boolean canUnify(SList constructor, Environment env) {
        cat.debug((Object)("canUnify: " + this.toString() + " with sort constructor " + constructor));
        if (!this.isCompound()) {
            cat.debug((Object)"no, because this isn't compound");
            return false;
        }
        if (this.list().size() != constructor.size()) {
            cat.debug((Object)"no, because number of subsorts differs");
            return false;
        }
        int i = 0;
        while (i < this.list().size()) {
            SortTemplate nameOrSubsort = new SortTemplate(this.list().getSValue(i));
            if (!nameOrSubsort.canUnify(constructor.getSValue(i), env)) {
                cat.debug((Object)("no, because " + nameOrSubsort + " didn't unify with " + constructor.getSValue(i)));
                return false;
            }
            ++i;
        }
        cat.debug((Object)("successfully unified " + this.value + " with " + constructor));
        return true;
    }

    public SValue toSexp() {
        return this.value;
    }

    public String getName() {
        if (this.isSimple()) {
            return this.value.toString();
        }
        if (this.isCompound()) {
            SList list = (SList)this.value;
            try {
                return list.getString(0);
            }
            catch (SValueException e) {
                throw new RuntimeException("Compound sort doesn't have a name");
            }
        }
        throw new RuntimeException("Can't get the name of a nameless sort.");
    }

    protected SList list() {
        return (SList)this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SortTemplate) {
            SortTemplate st = (SortTemplate)o;
            return this.value.equals((Object)st.value);
        }
        return false;
    }
}

