/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Binding;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.Constructor;
import com.veromodo.tioa.registry.Environment;
import com.veromodo.tioa.registry.Impl;
import com.veromodo.tioa.registry.InvalidTemplateException;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortImpl;
import com.veromodo.tioa.registry.SortTemplate;

public abstract class SortConstructor
extends Constructor
implements SortImpl {
    protected SortTemplate sortTemplate;

    public SortConstructor(SortTemplate sortTemplate) {
        super(sortTemplate.toString());
        this.sortTemplate = sortTemplate;
    }

    public SortConstructor(String sortTemplateString) throws InvalidTemplateException {
        super(sortTemplateString);
        this.sortTemplate = new SortTemplate(sortTemplateString);
    }

    protected abstract SortImpl construct(Sort var1, Environment var2) throws RegistryException;

    protected Impl construct(Binding binding, Environment env) throws RegistryException {
        Sort sort = (Sort)binding;
        return this.construct(sort, env);
    }

    public SortImpl getImpl(Sort sort) throws RegistryException {
        Environment env = new Environment();
        if (this.sortTemplate.canUnify(new SortTemplate(sort), env)) {
            return this.construct(sort, env);
        }
        return null;
    }

    public Impl getImpl(Binding binding) throws RegistryException {
        Sort sort = (Sort)binding;
        return this.getImpl(sort);
    }
}

