/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ClassSortImpl;
import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.ImplFactory;
import com.veromodo.tioa.registry.Parameterized;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.runtime.adt.Parameterization;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;

public class Parameterizer {
    public static Parameterization getParameterization(Sort sort) throws RegistryException {
        ImplFactory fact = ImplFactory.getInstance();
        ConstrImplRegistry reg = (ConstrImplRegistry)ConstrImplRegistry.getInstance();
        if (sort.isEnum()) {
            Object[] shorthandInfo = new Object[]{sort.getEnumEltNames().toArray()};
            return fact.newShorthandParameterization(shorthandInfo);
        }
        if (sort.isTuple() || sort.isUnion()) {
            Object[] shorthandInfo = new Object[3];
            Vector fieldNames = sort.getFieldNames();
            LinkedList<Class> implementationClasses = new LinkedList<Class>();
            LinkedList<Parameterization> parameterizations = new LinkedList<Parameterization>();
            for (Sort fieldSort : sort.getFieldSorts()) {
                ClassSortImpl impl = (ClassSortImpl)((Object)reg.getImpl(fieldSort));
                implementationClasses.add(impl.getImplClass());
                parameterizations.add(((Parameterized)fieldSort).getParameterization());
            }
            shorthandInfo[0] = fieldNames.toArray();
            shorthandInfo[1] = implementationClasses.toArray();
            shorthandInfo[2] = parameterizations.toArray();
            return fact.newShorthandParameterization(shorthandInfo);
        }
        int numSubsorts = sort.getSubsorts().size();
        if (numSubsorts == 0) {
            return fact.newEmptyParameterization();
        }
        Enumeration subsorts = sort.enumSubsorts();
        Class[] implementationClasses = new Class[numSubsorts];
        Parameterization[] parameterizations = new Parameterization[numSubsorts];
        int i = 0;
        while (i < numSubsorts) {
            Sort subsort = (Sort)subsorts.nextElement();
            ClassSortImpl impl = (ClassSortImpl)((Object)reg.getImpl(subsort));
            implementationClasses[i] = impl.getImplClass();
            parameterizations[i] = ((Parameterized)subsort).getParameterization();
            ++i;
        }
        return fact.newConstructorParameterization(implementationClasses, parameterizations);
    }
}

