/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.Environment;
import com.veromodo.tioa.registry.InvalidTemplateException;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortTemplate;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SValueException;
import java.util.Iterator;

public class OpTemplate {
    private static final IOACategory cat = IOACategory.getInstance((String)OpTemplate.class.getName());
    protected SList list;
    protected String name;
    protected int arity;
    static /* synthetic */ Class class$0;

    public OpTemplate(String template) throws InvalidTemplateException {
        this.initByParsing(template);
    }

    public OpTemplate(String template, SortTemplate meSort) throws InvalidTemplateException {
        this.initByParsing(template);
        this.desugar(meSort);
        cat.debug((Object)("Desugaring " + template + " to " + this.list.toString()));
    }

    public OpTemplate(Operator operator) {
        SValue opName = SExp.makeSValue((String)operator.getName());
        SList domain = new SList();
        Iterator iter = operator.getDomain().iterator();
        while (iter.hasNext()) {
            SortTemplate st = new SortTemplate((Sort)iter.next());
            domain.add((Object)st.toSexp());
        }
        SValue range = new SortTemplate(operator.getRange()).toSexp();
        this.list = SExp.makeSList((SValue)opName, (SValue)domain, (SValue)range);
        this.name = opName.toString();
    }

    public boolean canUnify(OpTemplate template, Environment env) {
        cat.debug((Object)("canUnify: " + this.list + " with " + template));
        if (this.list.size() != template.list.size()) {
            return false;
        }
        if (!this.getName().equals(template.getName())) {
            cat.debug((Object)"no, because operator names differ");
            return false;
        }
        SList myDomain = this.getDomainSList();
        SList itsDomain = template.getDomainSList();
        if (myDomain.size() != itsDomain.size()) {
            cat.debug((Object)"no, because arities differ");
            return false;
        }
        int i = 0;
        while (i < myDomain.size()) {
            SortTemplate domainSort = new SortTemplate(myDomain.getSValue(i));
            if (!domainSort.canUnify(itsDomain.getSValue(i), env)) {
                cat.debug((Object)"no, because domain sort didn't match");
                return false;
            }
            ++i;
        }
        SortTemplate rangeSort = new SortTemplate(this.getRangeSValue());
        if (!rangeSort.canUnify(template.getRangeSValue(), env)) {
            cat.debug((Object)"no, because range sort didn't match");
            return false;
        }
        cat.debug((Object)("successfully unified " + this.list + " with " + template));
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public String getRange() throws RegistryException {
        try {
            return this.list.getString(2);
        }
        catch (SValueException e) {
            throw new RegistryException("getRange() only supports unparameterized ranges", (Exception)((Object)e));
        }
    }

    public String[] getDomain() throws RegistryException {
        try {
            SList domain = this.list.getSList(1);
            String[] result = new String[this.getArity()];
            int i = 0;
            while (i < this.getArity()) {
                if (domain.get(i) instanceof SList) {
                    result[i] = domain.getSList(i).toString();
                    cat.debug((Object)("Adding Slist in domain:" + result[i]));
                } else {
                    result[i] = domain.getString(i);
                    cat.debug((Object)"Adding String in domain");
                }
                ++i;
            }
            return result;
        }
        catch (SValueException e) {
            throw new RegistryException((Exception)((Object)e));
        }
    }

    protected void initByParsing(String template) throws InvalidTemplateException {
        try {
            SParser parser = new SParser();
            this.list = (SList)parser.parse(template);
            this.name = this.list.getString(0);
            this.arity = this.list.getSList(1).size();
            Assert.assertTrue(this.list.size() == 3);
        }
        catch (Exception e) {
            throw new InvalidTemplateException("invalid s-expression", e);
        }
    }

    protected void desugar(SortTemplate meSort) {
        if (meSort == null) {
            return;
        }
        SValue pattern = SExp.makeSValue((String)"%me");
        SValue replacement = meSort.toSexp();
        this.list = (SList)this.list.replace(pattern, replacement);
    }

    protected SList getDomainSList() {
        try {
            return this.list.getSList(1);
        }
        catch (SValueException e) {
            throw new RuntimeException("invalid OpTemplate");
        }
    }

    protected SValue getRangeSValue() {
        return this.list.getSValue(2);
    }

    public SValue toSexp() {
        return this.list;
    }

    public String toString() {
        return this.list.toString();
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof OpTemplate && this.list.equals((Object)((OpTemplate)o).list);
    }
}

