/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Binding;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.registry.Constructor;
import com.veromodo.tioa.registry.Environment;
import com.veromodo.tioa.registry.Impl;
import com.veromodo.tioa.registry.InvalidTemplateException;
import com.veromodo.tioa.registry.OpImpl;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;

public abstract class OpConstructor
extends Constructor
implements OpImpl {
    protected OpTemplate opTemplate;

    public OpConstructor(OpTemplate opTemplate) {
        super(opTemplate.toString());
        this.opTemplate = opTemplate;
    }

    public OpConstructor(String opTemplateString) throws InvalidTemplateException {
        super(opTemplateString);
        this.opTemplate = new OpTemplate(opTemplateString);
    }

    protected abstract OpImpl construct(Operator var1, Environment var2) throws RegistryException;

    protected Impl construct(Binding binding, Environment env) throws RegistryException {
        Operator op = (Operator)binding;
        return this.construct(op, env);
    }

    public OpImpl getImpl(Operator op) throws RegistryException {
        Environment env = new Environment();
        if (this.opTemplate.canUnify(new OpTemplate(op), env)) {
            return this.construct(op, env);
        }
        return null;
    }

    public Impl getImpl(Binding binding) throws RegistryException {
        Operator op = (Operator)binding;
        return this.getImpl(op);
    }
}

