/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.OpConstructor;
import com.veromodo.tioa.registry.OpTemplate;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortConstructor;
import com.veromodo.tioa.registry.SortTemplate;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Vector;

public abstract class Installer {
    private static final IOACategory cat = IOACategory.getInstance((String)Installer.class.getName());
    protected final String implClassName;
    protected String sortName;
    protected final String implPackage;
    protected final String implClass;
    protected final ConstrImplRegistry registry;
    protected SortTemplate currentSortTemplate;
    static /* synthetic */ Class class$0;

    public Installer(String implClass, ConstrImplRegistry registry) {
        if (StringOps.classNameIsFullyQualified(implClass)) {
            this.implPackage = StringOps.packageNameOfClass(implClass);
            this.implClassName = StringOps.shortNameOfClass(implClass);
        } else {
            cat.debug((Object)"assuming impl package com.veromodo.tioa.runtime.adt");
            this.implPackage = "com.veromodo.tioa.runtime.adt";
            this.implClassName = implClass;
        }
        this.implClass = String.valueOf(this.implPackage) + "." + this.implClassName;
        this.sortName = null;
        this.registry = registry;
    }

    protected void addSort(String template, boolean isLiteral) throws RegistryException {
        cat.debug((Object)("addSort " + template));
        template = this.ensureWrapped(template);
        this.currentSortTemplate = new SortTemplate(template);
        this.sortName = this.currentSortTemplate.getName();
        SortConstructor sort = this.sortConstructorHook(isLiteral, this.currentSortTemplate);
        this.registry.add(this.sortName, isLiteral, sort);
        this.addStandardOps(template);
    }

    public void addSort(String template) throws RegistryException {
        this.addSort(template, false);
    }

    public void addLiteralSort(String template) throws RegistryException {
        this.addSort(template, true);
    }

    protected abstract SortConstructor sortConstructorHook(boolean var1, SortTemplate var2) throws RegistryException;

    public void addOp(String opTemplateString, String methodName) throws RegistryException {
        OpTemplate template = new OpTemplate(opTemplateString, this.currentSortTemplate);
        OpConstructor op = this.opConstructorHook(template, methodName);
        this.registry.add(template.getName(), op);
    }

    protected abstract OpConstructor opConstructorHook(OpTemplate var1, String var2) throws RegistryException;

    public void addShortcutOp(String opTemplateString, String methodName, String shortcutStyle) throws RegistryException {
        OpTemplate template = new OpTemplate(opTemplateString, this.currentSortTemplate);
        OpConstructor op = this.shortcutOpConstructorHook(template, methodName, shortcutStyle);
        this.registry.add(template.getName(), op);
    }

    protected OpConstructor shortcutOpConstructorHook(OpTemplate template, String methodName, String shortcutStyle) throws RegistryException {
        return this.opConstructorHook(template, methodName);
    }

    public void addAssignOp(String opTemplateString, String methodName, String assignMethod) throws RegistryException {
        OpTemplate template = new OpTemplate(opTemplateString, this.currentSortTemplate);
        OpConstructor op = this.assignOpConstructorHook(template, methodName, assignMethod);
        this.registry.add(template.getName(), op);
    }

    protected abstract OpConstructor assignOpConstructorHook(OpTemplate var1, String var2, String var3) throws RegistryException;

    public void addCurriedOp(String opTemplateString, String methodName, Vector builtIns) throws RegistryException {
        this.addCurriedOp(opTemplateString, methodName, builtIns, false);
    }

    public void addCurriedOp(String opTemplateString, String methodName, Vector builtIns, boolean arrayMode) throws RegistryException {
        int numParameters;
        cat.debug((Object)("addCurriedOp: " + opTemplateString));
        OpTemplate opTemplate = new OpTemplate(opTemplateString);
        String[] domain = opTemplate.getDomain();
        int n = numParameters = domain == null ? 0 : domain.length;
        if (arrayMode) {
            numParameters = 1;
        }
        OpConstructor opConstr = this.curriedOpConstrHook(opTemplate, methodName, builtIns, arrayMode, numParameters);
        this.registry.add(opTemplate.getName(), opConstr);
    }

    protected abstract OpConstructor curriedOpConstrHook(OpTemplate var1, String var2, Vector var3, boolean var4, int var5) throws RegistryException;

    public void addAssignableCurriedOp(String opTemplateString, String methodName, String assignMethodName, Vector builtIns, boolean arrayMode) throws RegistryException {
        int numParameters;
        cat.debug((Object)("addAssignableCurriedOp: " + opTemplateString));
        OpTemplate opTemplate = new OpTemplate(opTemplateString);
        String[] domain = opTemplate.getDomain();
        int n = numParameters = domain == null ? 0 : domain.length;
        if (arrayMode) {
            numParameters = 1;
        }
        OpConstructor opConstr = this.assignableCurriedOpConstrHook(opTemplate, methodName, assignMethodName, builtIns, arrayMode, numParameters);
        this.registry.add(opTemplate.getName(), opConstr);
    }

    protected abstract OpConstructor assignableCurriedOpConstrHook(OpTemplate var1, String var2, String var3, Vector var4, boolean var5, int var6) throws RegistryException;

    protected void addStandardOps(String template) throws RegistryException {
        this.addOp("(__=__ (%me %me) Bool)", "equals");
        this.addOp("(__~=__ (%me %me) Bool)", "notEquals");
        this.addShortcutOp("(@<if> (Bool %me %me) %me)", "ifThenElse", "if");
    }

    public Sort sortNameToSort(String name) throws ILException {
        ILFactory fact = ILFactory.getInstance();
        return fact.newSort("s0", name, new Vector(), name.equals("Int"), name.equals("Bool"), false, false, null);
    }

    protected String ensureWrapped(String sortTemplate) throws RegistryException {
        try {
            SParser parser = new SParser();
            SValue value = parser.parse(sortTemplate);
            if (!(value instanceof SList)) {
                return "(" + sortTemplate + ")";
            }
            return sortTemplate;
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }
}

