/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.registry.ImplNotFoundException;
import com.veromodo.tioa.registry.ImplRegistry;
import com.veromodo.tioa.registry.OpConstructor;
import com.veromodo.tioa.registry.OpImpl;
import com.veromodo.tioa.registry.Registrable;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.registry.SortConstructor;
import com.veromodo.tioa.registry.SortImpl;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConstrImplRegistry
extends ImplRegistry {
    static final IOACategory cat = IOACategory.getInstance((String)ConstrImplRegistry.class.getName());
    protected Map sortConTable = new HashMap();
    protected Map opConTable = new HashMap();
    protected Map sortTable = new HashMap();
    protected Map opTable = new HashMap();
    static /* synthetic */ Class class$0;

    public static String makeOpKey(String name, String range, String[] domain) {
        StringBuffer buf = new StringBuffer().append(name).append("@{");
        buf.append(range).append("@[]@");
        if (domain != null) {
            int i = 0;
            while (i < domain.length) {
                buf.append("$").append(domain[i]).append("@[]@");
                ++i;
            }
        }
        return buf.append("}@").toString();
    }

    public static String makeOpKey(String name, String range) {
        return ConstrImplRegistry.makeOpKey(name, range, null);
    }

    public static String makeSortKey(String name) {
        return String.valueOf(name) + "@[]@";
    }

    public static List listForKey(Map table, Object key) {
        if (!table.containsKey(key)) {
            cat.debug((Object)("Adding List for key: " + key));
            table.put(key, new LinkedList());
        }
        return (List)table.get(key);
    }

    public ConstrImplRegistry() throws RegistryException {
    }

    public ConstrImplRegistry(String[] packages) throws RegistryException {
        try {
            int i = 0;
            while (i < packages.length) {
                cat.debug((Object)("ConstrImplRegistry; installing package:" + packages[i]));
                Class<?> registrationClass = Class.forName(packages[i]);
                Registrable instance = (Registrable)registrationClass.newInstance();
                instance.install(this);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RegistryException("instantiating and installing registration class", e);
        }
    }

    public SortImpl getImpl(Sort sort) throws RegistryException {
        cat.debug((Object)("getImpl: \"" + sort.getKey() + "\""));
        SortImpl impl = (SortImpl)this.sortTable.get(sort.getKey());
        if (impl != null) {
            cat.debug((Object)("\t" + sort.getKey() + ": found instantiated"));
            return impl;
        }
        List sortConstructorList = ConstrImplRegistry.listForKey(this.sortConTable, sort.getName());
        cat.debug((Object)("sortConstructorList = " + sortConstructorList));
        for (SortConstructor sortConstructor : sortConstructorList) {
            SortImpl sortImpl = sortConstructor.getImpl(sort);
            if (sortImpl == null) continue;
            cat.debug((Object)("\t" + sort.getKey() + ": found template match"));
            return sortImpl;
        }
        cat.debug((Object)("\t" + sort.getKey() + ": not found statically"));
        throw new ImplNotFoundException("Sort: " + sort);
    }

    public OpImpl getImpl(Operator op) throws RegistryException {
        cat.debug((Object)("getImpl: " + op.getId() + " \"" + op.getKey() + "\""));
        OpImpl impl = (OpImpl)this.opTable.get(op.getKey());
        if (impl != null) {
            cat.debug((Object)("\t" + op.getKey() + ": found instantiated"));
            return impl;
        }
        List opConstructorList = ConstrImplRegistry.listForKey(this.opConTable, op.getName());
        cat.debug((Object)("opConstructorList = " + opConstructorList));
        for (OpConstructor opConstructor : opConstructorList) {
            OpImpl opImpl = opConstructor.getImpl(op);
            if (opImpl == null) continue;
            cat.debug((Object)("\t" + op.getKey() + ": found template match"));
            return opImpl;
        }
        cat.debug((Object)("\t" + op.getKey() + " not found statically."));
        throw new ImplNotFoundException("Operator: " + op);
    }

    public void add(String name, boolean isLiteral, SortConstructor sortCon) {
        cat.debug((Object)("add sort: \"" + name + "\""));
        ConstrImplRegistry.listForKey(this.sortConTable, name).add(sortCon);
    }

    public void add(String name, OpConstructor opCon) {
        cat.debug((Object)("add op: \"" + name + "\""));
        ConstrImplRegistry.listForKey(this.opConTable, name).add(opCon);
    }

    public void add(String key, boolean isLiteral, SortImpl impl) {
        cat.debug((Object)("add: \"" + key + "\""));
        this.sortTable.put(key, impl);
    }

    public void add(String key, OpImpl impl) {
        cat.debug((Object)("add: \"" + key + "\""));
        this.opTable.put(key, impl);
    }
}

