/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.registry;

import com.veromodo.tioa.registry.ConstrImplRegistry;
import com.veromodo.tioa.registry.Registrable;
import com.veromodo.tioa.registry.RegistryException;
import com.veromodo.tioa.simulator.shell.SimShell;
import com.veromodo.tioa.util.ClassLocator;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.IOAException;
import com.veromodo.tioa.util.logger.IOACategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ADTLoader {
    private static IOACategory debug = IOACategory.getInstance((String)ADTLoader.class.getName());
    protected static String pathSeparator = System.getProperty("path.separator");
    protected static String fileSeparator = System.getProperty("file.separator");
    protected static String prefix = "tioa.";
    public static ADTLoader adtLoader = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void installRegistrableClasses(ConstrImplRegistry ciRegistry) throws RegistryException {
        for (String className : this.getRegistrableClasses()) {
            try {
                Class<?> classObject = Class.forName(className);
                Registrable classInstance = (Registrable)classObject.newInstance();
                if (debug.isDebugEnabled()) {
                    debug.debug((Object)("Loading class " + classObject.getName()));
                }
                classInstance.install(ciRegistry);
            }
            catch (InstantiationException e) {
                throw new RegistryException("Unable to register " + className + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RegistryException("IllegalAccessException" + className + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RegistryException("ClassNotFound" + className + e.getMessage());
            }
        }
    }

    public List listProperties(Properties p, String name) {
        String propertyString = p.getProperty(name);
        if (propertyString == null) {
            return new ArrayList();
        }
        StringTokenizer propertyTokens = new StringTokenizer(propertyString, pathSeparator);
        return CollectionsUtils.enumerationToList(propertyTokens);
    }

    public Set getRegistrableClasses() throws RegistryException {
        Properties properties = new Properties();
        try {
            File tioafile = new File(System.getProperty("user.home"), ".tioa");
            FileInputStream tioafileIS = new FileInputStream(tioafile);
            properties.load(tioafileIS);
        }
        catch (IOException tioafile) {
            // empty catch block
        }
        try {
            int i = 0;
            while (i < SimShell.configFiles.size()) {
                properties.load(SimShell.configFiles.get(i));
                ++i;
            }
            List locationOfPackages = this.listProperties(properties, String.valueOf(prefix) + "locationOfPackages");
            List listOfPackages = this.listProperties(properties, String.valueOf(prefix) + "listOfPackages");
            debug.debug((Object)("locationOfPackages=" + locationOfPackages));
            Class<Registrable> interfaceClass = Registrable.class;
            ClassLocator classLocator = new ClassLocator();
            return classLocator.getImplementorsOf(interfaceClass, locationOfPackages, listOfPackages, new ArrayList<String>(), new ArrayList<String>());
        }
        catch (ClassNotFoundException e) {
            System.err.println(IOAException.getStackTraceAsString(e));
            throw new RegistryException(e);
        }
        catch (IOException e) {
            throw new RegistryException(e.getMessage());
        }
    }
}

