% 6.888 Wireless Communications Systems
%
% Dina Katabi / Haitham Hassnaieh 
% CSAIL, MIT 
% September 11, 2013
%
addpath ../SRC_CODE
load ../Mat_Files/Test_2x2_Diversity_R.mat
load ../Mat_Files/Parameters.mat

[T1_bits_data_NA] = decode_2x2_no_alamouti(rx_signal_1_NA_T1,rx_signal_2_NA_T1);
[T2_bits_data_NA] = decode_2x2_no_alamouti(rx_signal_1_NA_T2,rx_signal_2_NA_T2);
[T3_bits_data_NA] = decode_2x2_no_alamouti(rx_signal_1_NA_T3,rx_signal_2_NA_T3);
[T4_bits_data_NA] = decode_2x2_no_alamouti(rx_signal_1_NA_T4,rx_signal_2_NA_T4);

[T1_bits_data_A] = decode_2x2_with_alamouti(rx_signal_1_A_T1,rx_signal_2_A_T1);
[T2_bits_data_A] = decode_2x2_with_alamouti(rx_signal_1_A_T2,rx_signal_2_A_T2);
[T3_bits_data_A] = decode_2x2_with_alamouti(rx_signal_1_A_T3,rx_signal_2_A_T3);
[T4_bits_data_A] = decode_2x2_with_alamouti(rx_signal_1_A_T4,rx_signal_2_A_T4);

BER_NA_T1 = sum(abs(bits_data_T1 - T1_bits_data_NA))/length(bits_data_T1);
BER_A_T1 = sum(abs(bits_data_T1 - T1_bits_data_A))/length(bits_data_T1);

BER_NA_T2 = sum(abs(bits_data_T2 - T2_bits_data_NA))/length(bits_data_T2);
BER_A_T2 = sum(abs(bits_data_T2 - T2_bits_data_A))/length(bits_data_T2);

BER_NA_T3 = sum(abs(bits_data_T3 - T3_bits_data_NA))/length(bits_data_T3);
BER_A_T3 = sum(abs(bits_data_T3 - T3_bits_data_A))/length(bits_data_T3);


save ../Results/Result_2x2_Diversity.mat T*_bits_data_* BER*

