function [ bits_data ] = rx_ofdm_chain_synced(rx_signal)
% 6.888 Wireless Communications Systems
%
% Dina Katabi / Haitham Hassnaieh 
% CSAIL, MIT 
% September 30, 2013
%

load ../Mat_Files/Parameters.mat

bits_data = [];

% Use this variable to help you set the data subcarriers from pilot
% subcarriers from unused subcarriers
subcarrier_config = ones(1,num_bins);
subcarrier_config(convert_bin_index_normal_to_fft(gaurd_bins,num_bins)) = 0;
subcarrier_config(convert_bin_index_normal_to_fft(pilots,num_bins)) = 3; 

current_index = 1;

%% CHANNEL ESTIMATION
h = estimate_channel(rx_signal(current_index:current_index+num_bins-1),rx_signal(current_index+num_bins:current_index+2*num_bins-1));
current_index = current_index + 2*num_bins +cp;

%% DECODING
for m = 1:1:num_syms_data
    symt = rx_signal(current_index:current_index+num_bins-1);
    symf = (1/sqrt(num_bins))*fft(symt);
    symf = correct_channel(symf,h); 
    bits = symf(subcarrier_config==1) < 0;
    bits_data = [bits_data, bits];
    current_index = current_index + num_bins + cp;
end

end