/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.whb21.xmlrpcApplet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlrpc.applet.XmlRpcException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.cam.cl.whb21.xmlrpcApplet.SimpleTypeFactory;

class XmlRpcSupport
extends DefaultHandler {
    private SimpleTypeFactory typeFactory;
    URL url;
    String methodName;
    boolean fault = false;
    Object result = null;
    Stack values;
    Value currentValue;
    boolean readCdata;
    static final DateFormat format = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    StringBuffer cdata = new StringBuffer();
    static final int STRING = 0;
    static final int INTEGER = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int DATE = 4;
    static final int BASE64 = 5;
    static final int STRUCT = 6;
    static final int ARRAY = 7;
    public static boolean debug = false;
    static final String[] types = new String[]{"String", "Integer", "Boolean", "Double", "Date", "Base64", "Struct", "Array"};

    public XmlRpcSupport(URL url) {
        this.url = url;
        this.typeFactory = new SimpleTypeFactory();
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    synchronized void parse(InputStream is) throws Exception {
        this.values = new Stack();
        long now = System.currentTimeMillis();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(is, (DefaultHandler)this);
        if (debug) {
            System.out.println("Spent " + (System.currentTimeMillis() - now) + " parsing");
        }
    }

    void writeObject(Object what, XmlWriter writer) throws IOException {
        writer.startElement("value");
        if (what instanceof String) {
            writer.startElement("string");
            writer.write(what.toString());
            writer.endElement("string");
        } else if (what instanceof Integer) {
            writer.startElement("int");
            writer.write(what.toString());
            writer.endElement("int");
        } else if (what instanceof Boolean) {
            writer.startElement("boolean");
            writer.write((Boolean)what != false ? "1" : "0");
            writer.endElement("boolean");
        } else if (what instanceof Double) {
            writer.startElement("double");
            writer.write(what.toString());
            writer.endElement("double");
        } else if (what instanceof Date) {
            writer.startElement("dateTime.iso8601");
            Date d = (Date)what;
            writer.write(format.format(d));
            writer.endElement("dateTime.iso8601");
        } else if (what instanceof byte[]) {
            writer.startElement("base64");
            writer.endElement("base64");
        } else if (what instanceof Vector) {
            writer.startElement("array");
            writer.startElement("data");
            Vector v = (Vector)what;
            int l2 = v.size();
            int i2 = 0;
            while (i2 < l2) {
                this.writeObject(v.elementAt(i2), writer);
                ++i2;
            }
            writer.endElement("data");
            writer.endElement("array");
        } else if (what instanceof Hashtable) {
            writer.startElement("struct");
            Hashtable h = (Hashtable)what;
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String nextkey = (String)e.nextElement();
                Object nextval = h.get(nextkey);
                writer.startElement("member");
                writer.startElement("name");
                writer.write(nextkey);
                writer.endElement("name");
                this.writeObject(nextval, writer);
                writer.endElement("member");
            }
            writer.endElement("struct");
        } else {
            String unsupportedType = what == null ? "null" : what.getClass().toString();
            throw new IOException("unsupported Java type: " + unsupportedType);
        }
        writer.endElement("value");
    }

    public Object execute(String method, Vector arguments) throws XmlRpcException, IOException {
        this.fault = false;
        long now = System.currentTimeMillis();
        try {
            StringBuffer strbuf = new StringBuffer();
            XmlWriter writer = new XmlWriter(strbuf);
            this.writeRequest(writer, method, arguments);
            String requestString = strbuf.toString();
            System.out.println("XMLRPC Request: \n" + requestString);
            byte[] request = requestString.getBytes();
            URLConnection con = this.url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.setRequestProperty("Content-Length", Integer.toString(request.length));
            con.setRequestProperty("Content-Type", "text/xml");
            OutputStream out = con.getOutputStream();
            out.write(request);
            out.flush();
            InputStream in = con.getInputStream();
            this.parse(in);
            System.out.println("result = " + this.result);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new IOException(x.getMessage());
        }
        if (this.fault) {
            XmlRpcException exception = null;
            try {
                Hashtable f = (Hashtable)this.result;
                String faultString = (String)f.get("faultString");
                int faultCode = Integer.parseInt(f.get("faultCode").toString());
                exception = new XmlRpcException(faultCode, faultString.trim());
            }
            catch (Exception x) {
                throw new XmlRpcException(0, "Invalid fault response");
            }
            throw exception;
        }
        System.out.println("Spent " + (System.currentTimeMillis() - now) + " in request");
        return this.result;
    }

    void objectParsed(Object what) {
        this.result = what;
    }

    void writeRequest(XmlWriter writer, String method, Vector params) throws IOException {
        writer.startElement("methodCall");
        writer.startElement("methodName");
        writer.write(method);
        writer.endElement("methodName");
        writer.startElement("params");
        int l = params.size();
        int i = 0;
        while (i < l) {
            writer.startElement("param");
            this.writeObject(params.elementAt(i), writer);
            writer.endElement("param");
            ++i;
        }
        writer.endElement("params");
        writer.endElement("methodCall");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.readCdata) {
            return;
        }
        this.cdata.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        int depth;
        if (debug) {
            System.err.println("endElement localName:" + localName + " qName:" + qName);
        }
        if (this.currentValue != null && this.readCdata) {
            this.currentValue.characterData(this.cdata.toString());
            this.cdata.setLength(0);
            this.readCdata = false;
        }
        if (("value".equals(localName) || "value".equals(qName)) && ((depth = this.values.size()) < 2 || this.values.elementAt(depth - 2).hashCode() != 6)) {
            Value v = this.currentValue;
            this.values.pop();
            if (depth < 2) {
                this.objectParsed(v.value);
                this.currentValue = null;
            } else {
                this.currentValue = (Value)this.values.peek();
                this.currentValue.endElement(v);
            }
        }
        if ("member".equals(localName) || "member".equals(qName)) {
            Value v = this.currentValue;
            this.values.pop();
            this.currentValue = (Value)this.values.peek();
            this.currentValue.endElement(v);
        } else if ("methodName".equals(localName) || "methodName".equals(qName)) {
            this.methodName = this.cdata.toString();
            this.cdata.setLength(0);
            this.readCdata = false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (debug) {
            System.err.println("startElement localName:" + localName + " qName:" + qName);
        }
        if ("fault".equals(localName) || "fault".equals(qName)) {
            this.fault = true;
        } else if ("value".equals(localName) || "value".equals(qName)) {
            Value v = new Value();
            this.values.push(v);
            this.currentValue = v;
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("methodName".equals(localName) || "methodName".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("name".equals(localName) || "name".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("string".equals(localName) || "string".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("i4".equals(localName) || "int".equals(localName) || "i4".equals(qName) || "int".equals(qName)) {
            this.currentValue.setType(1);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("boolean".equals(localName) || "boolean".equals(qName)) {
            this.currentValue.setType(2);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("double".equals(localName) || "double".equals(qName)) {
            this.currentValue.setType(3);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("dateTime.iso8601".equals(localName) || "dateTime.iso8601".equals(qName)) {
            this.currentValue.setType(4);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("base64".equals(localName) || "base64".equals(qName)) {
            this.currentValue.setType(5);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("struct".equals(localName) || "struct".equals(qName)) {
            this.currentValue.setType(6);
        } else if ("array".equals(localName) || "array".equals(qName)) {
            this.currentValue.setType(7);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error parsing XML: " + e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal error parsing XML: " + e);
    }

    class Value {
        int type = 0;
        Object value;
        String nextMemberName;
        Hashtable struct;
        Vector array;

        public void endElement(Value child) {
            if (this.type == 7) {
                this.array.addElement(child.value);
            } else if (this.type == 6) {
                this.struct.put(this.nextMemberName, child.value);
            }
        }

        public void setType(int type) {
            this.type = type;
            if (type == 7) {
                this.array = new Vector();
                this.value = this.array;
            }
            if (type == 6) {
                this.struct = new Hashtable();
                this.value = this.struct;
            }
        }

        public void characterData(String cdata) {
            switch (this.type) {
                case 1: {
                    this.value = new Integer(cdata.trim());
                    break;
                }
                case 2: {
                    this.value = new Boolean("1".equals(cdata.trim()));
                    break;
                }
                case 3: {
                    this.value = new Double(cdata.trim());
                    break;
                }
                case 4: {
                    try {
                        this.value = format.parse(cdata.trim());
                        break;
                    }
                    catch (ParseException p) {
                        throw new RuntimeException(p.getMessage());
                    }
                }
                case 5: {
                    this.value = XmlRpcSupport.this.typeFactory.createBase64(cdata);
                    break;
                }
                case 0: {
                    this.value = cdata;
                    break;
                }
                case 6: {
                    this.nextMemberName = cdata;
                }
            }
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return String.valueOf(types[this.type]) + " element " + this.value;
        }
    }

    class XmlWriter {
        StringBuffer buf;
        String enc;

        public XmlWriter(StringBuffer buf) {
            this.buf = buf;
            buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        }

        public void startElement(String elem) {
            this.buf.append("<");
            this.buf.append(elem);
            this.buf.append(">");
        }

        public void endElement(String elem) {
            this.buf.append("</");
            this.buf.append(elem);
            this.buf.append(">");
        }

        public void emptyElement(String elem) {
            this.buf.append("<");
            this.buf.append(elem);
            this.buf.append("/>");
        }

        public void chardata(String text) {
            int l = text.length();
            int i = 0;
            while (i < l) {
                char c = text.charAt(i);
                switch (c) {
                    case '<': {
                        this.buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        this.buf.append("&gt;");
                        break;
                    }
                    case '&': {
                        this.buf.append("&amp;");
                        break;
                    }
                    default: {
                        this.buf.append(c);
                    }
                }
                ++i;
            }
        }

        public void write(byte[] text) {
            this.buf.append(text);
        }

        public void write(char[] text) {
            this.chardata(new String(text));
        }

        public void write(String text) {
            this.chardata(text);
        }

        public String toString() {
            return this.buf.toString();
        }

        public byte[] getBytes() throws UnsupportedEncodingException {
            return this.buf.toString().getBytes();
        }
    }
}

