/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.whb21.xmlrpcApplet;

import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.cam.cl.whb21.xmlrpcApplet.SimpleTypeFactory;

public class SimplifiedXmlRpc
extends DefaultHandler {
    Vector requestParams;
    String methodName;
    Stack values;
    Value currentValue;
    StringBuffer cdata;
    boolean readCdata;
    static final int STRING = 0;
    static final int INTEGER = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int DATE = 4;
    static final int BASE64 = 5;
    static final int STRUCT = 6;
    static final int ARRAY = 7;
    int errorLevel;
    String errorMsg;
    static final int NONE = 0;
    static final int RECOVERABLE = 1;
    static final int FATAL = 2;
    static final String[] types = new String[]{"String", "Integer", "Boolean", "Double", "Date", "Base64", "Struct", "Array"};
    private SimpleTypeFactory typeFactory = new SimpleTypeFactory();

    protected SimplifiedXmlRpc() {
        this.requestParams = new Vector();
    }

    void parse(Reader is) throws Exception {
        this.errorLevel = 0;
        this.errorMsg = null;
        this.values = new Stack();
        if (this.cdata == null) {
            this.cdata = new StringBuffer(128);
        } else {
            this.cdata.setLength(0);
        }
        this.readCdata = false;
        this.currentValue = null;
        long now = System.currentTimeMillis();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(is), (DefaultHandler)this);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.readCdata) {
            this.cdata.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        System.out.println("endElement localName:" + localName + " qName:" + qName);
        if (this.currentValue != null && this.readCdata) {
            this.currentValue.characterData(this.cdata.toString());
            this.cdata.setLength(0);
            this.readCdata = false;
        }
        if ("value".equals(localName) || "value".equals(qName)) {
            int depth = this.values.size();
            System.out.println("depth: " + depth);
            if (depth < 2 || this.values.elementAt(depth - 2).hashCode() != 6) {
                Value v = this.currentValue;
                System.out.println("value " + v);
                this.values.pop();
                if (depth < 2) {
                    this.requestParams.addElement(v.value);
                    this.currentValue = null;
                } else {
                    this.currentValue = (Value)this.values.peek();
                    System.out.println("currentValue " + v);
                    this.currentValue.endElement(v);
                }
            }
        }
        if ("member".equals(localName) || "member".equals(qName)) {
            Value v = this.currentValue;
            this.values.pop();
            this.currentValue = (Value)this.values.peek();
            this.currentValue.endElement(v);
        } else if ("methodName".equals(localName) || "methodName".equals(qName)) {
            this.methodName = this.cdata.toString();
            this.cdata.setLength(0);
            this.readCdata = false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        System.out.println("startElement localName:" + localName + " qName:" + qName);
        if ("value".equals(localName) || "value".equals(qName)) {
            Value v = new Value();
            this.values.push(v);
            this.currentValue = v;
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("methodName".equals(localName) || "methodName".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("name".equals(localName) || "name".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("string".equals(localName) || "string".equals(qName)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("i4".equals(localName) || "int".equals(localName) || "i4".equals(qName) || "int".equals(qName)) {
            this.currentValue.setType(1);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("boolean".equals(localName) || "boolean".equals(qName)) {
            this.currentValue.setType(2);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("double".equals(localName) || "double".equals(qName)) {
            this.currentValue.setType(3);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("dateTime.iso8601".equals(localName) || "dateTime.iso8601".equals(qName)) {
            this.currentValue.setType(4);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("base64".equals(localName) || "base64".equals(qName)) {
            this.currentValue.setType(5);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("struct".equals(localName) || "struct".equals(qName)) {
            this.currentValue.setType(6);
        } else if ("array".equals(localName) || "array".equals(qName)) {
            this.currentValue.setType(7);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error parsing XML: " + e);
        this.errorLevel = 1;
        this.errorMsg = e.toString();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal error parsing XML: " + e);
        this.errorLevel = 2;
        this.errorMsg = e.toString();
    }

    public String toString() {
        return "Method Name: " + this.methodName + " Vectors: " + this.requestParams;
    }

    class Value {
        int type = 0;
        Object value;
        String nextMemberName;
        Hashtable struct;
        Vector array;

        public void endElement(Value child) {
            switch (this.type) {
                case 7: {
                    this.array.addElement(child.value);
                    break;
                }
                case 6: {
                    this.struct.put(this.nextMemberName, child.value);
                }
            }
        }

        public void setType(int type) {
            this.type = type;
            switch (type) {
                case 7: {
                    this.value = this.array = new Vector();
                    break;
                }
                case 6: {
                    this.value = this.struct = new Hashtable();
                }
            }
        }

        public void characterData(String cdata) {
            switch (this.type) {
                case 1: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createInteger(cdata);
                    break;
                }
                case 2: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createBoolean(cdata);
                    break;
                }
                case 3: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createDouble(cdata);
                    break;
                }
                case 4: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createDate(cdata);
                    break;
                }
                case 5: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createBase64(cdata);
                    break;
                }
                case 0: {
                    this.value = SimplifiedXmlRpc.this.typeFactory.createString(cdata);
                    break;
                }
                case 6: {
                    this.nextMemberName = cdata;
                }
            }
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return String.valueOf(types[this.type]) + " element " + this.value;
        }
    }
}

