/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.whb21.xmlrpcApplet;

import java.applet.Applet;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;
import uk.ac.cam.cl.whb21.xmlrpcApplet.AppletXmlRpcCaller;
import uk.ac.cam.cl.whb21.xmlrpcApplet.SimplifiedXmlRpc;
import uk.ac.cam.cl.whb21.xmlrpcApplet.XmlRpcApplet;

public class ClientControllerApplet
extends XmlRpcApplet
implements AppletXmlRpcCaller {
    protected boolean debugNoServer = false;

    public void init() {
        super.init();
        System.out.println("ClientControllerApplet init");
        System.out.println("no Server: " + this.getParameter("NO_SERVER"));
        if ("TRUE".equals(this.getParameter("NO_SERVER"))) {
            System.out.println("ClientControllerApplet in debugNoServer mode");
            this.debugNoServer = true;
        }
    }

    public void start() {
        System.out.println("ClientControllerApplet start");
    }

    protected void processRequest(String request) {
        try {
            System.out.println("processRequest about to parse: " + request);
            StringReader sr = new StringReader(request);
            SimplifiedXmlRpc rpc = new SimplifiedXmlRpc();
            rpc.parse(sr);
            System.out.println("processRequest XMLRPC parsed: " + rpc);
            StringTokenizer tokenizer = new StringTokenizer(rpc.methodName, ".");
            if (tokenizer.countTokens() != 2) {
                System.err.println("Rpc not in applet.method format: " + rpc.methodName);
            }
            String appletName = tokenizer.nextToken();
            String methodName = tokenizer.nextToken();
            Class[] classList = new Class[rpc.requestParams.size()];
            Iterator i = rpc.requestParams.iterator();
            int j = 0;
            while (i.hasNext()) {
                classList[j] = i.next().getClass();
                ++j;
            }
            Applet a = this.getAppletContext().getApplet(appletName);
            if (a == null) {
                System.err.println("applet " + appletName + " not found");
                return;
            }
            Method m = a.getClass().getMethod(methodName, classList);
            if (m == null) {
                System.err.println("method " + appletName + "." + methodName + " not found");
                return;
            }
            System.out.println("about to execute the XMLRPC");
            m.invoke((Object)a, rpc.requestParams.toArray());
            System.out.println("executed the XMLRPC");
        }
        catch (Exception e) {
            System.out.println("exception e is " + e);
            e.printStackTrace();
        }
    }

    public void actionCall(String name, Vector arguments) {
        Object returnObject = this.returnCall(name, arguments);
        if (returnObject != null) {
            System.out.println("object returned from XMLRPC server is a: " + returnObject.getClass().getName());
            if (returnObject instanceof Vector) {
                Vector v = (Vector)returnObject;
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    System.out.println("object in vector: " + o.getClass().getName());
                    if (!(o instanceof String)) continue;
                    this.processRequest((String)o);
                }
            } else if (returnObject instanceof Object[]) {
                String[] a = (String[])returnObject;
                int i = 0;
                while (i < a.length) {
                    if (a[i] instanceof String) {
                        this.processRequest(a[i]);
                    }
                    ++i;
                }
            } else if (returnObject instanceof String) {
                this.processRequest((String)returnObject);
            }
        }
    }

    public Object returnCall(String name, Vector arguments) {
        if (this.debugNoServer) {
            JSObject win = JSObject.getWindow((Applet)this);
            String[] jsArgs = new String[2];
            String replacedArgs = arguments.toString().replaceAll("\"", "&quot;");
            jsArgs[0] = name;
            jsArgs[1] = replacedArgs;
            win.eval("printXmlRpcOutput('" + name + "', '" + arguments.toString() + "');");
            return null;
        }
        try {
            return this.execute(name, arguments);
        }
        catch (Exception e) {
            System.err.println("Exception in returnCall: " + e);
            return null;
        }
    }

    public void testResponseCall(String response) {
        this.processRequest(response);
    }
}

