/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import org.jaxen.ContextSupport;
import org.jaxen.Navigator;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Visitor;
import org.jaxen.expr.iter.IterableAxis;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    boolean hasPrefix;

    public DefaultNameStep(IterableAxis axis, String prefix, String localName, PredicateSet predicateSet) {
        super(axis, predicateSet);
        this.prefix = prefix;
        this.localName = localName;
        this.matchesAnyName = "*".equals(localName);
        this.hasPrefix = this.prefix != null && !"".equals(this.prefix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    public String getText() {
        if (this.getPrefix() != null && !this.getPrefix().equals("")) {
            return this.getAxisName() + "::" + this.getPrefix() + ":" + this.getLocalName() + super.getText();
        }
        return this.getAxisName() + "::" + this.getLocalName() + super.getText();
    }

    public String toString() {
        return "[(DefaultNameStep): " + this.getPrefix() + ":" + this.getLocalName() + "[" + super.toString() + "]]";
    }

    public boolean matches(Object node, ContextSupport contextSupport) {
        Navigator nav = contextSupport.getNavigator();
        String myUri = null;
        String nodeName = null;
        String nodeUri = null;
        if (nav.isElement(node)) {
            nodeName = nav.getElementName(node);
            nodeUri = nav.getElementNamespaceUri(node);
        } else if (nav.isAttribute(node)) {
            nodeName = nav.getAttributeName(node);
            nodeUri = nav.getAttributeNamespaceUri(node);
        } else {
            if (nav.isDocument(node)) {
                return !this.hasPrefix && this.matchesAnyName;
            }
            if (nav.isNamespace(node)) {
                if (this.matchesAnyName && this.getAxis() != 10) {
                    return false;
                }
                nodeName = nav.getNamespacePrefix(node);
            } else {
                return false;
            }
        }
        if (this.hasPrefix) {
            myUri = contextSupport.translateNamespacePrefixToUri(this.prefix);
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(myUri) != this.hasNamespace(nodeUri)) {
            return false;
        }
        if (this.matchesAnyName || nodeName.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(myUri, nodeUri);
        }
        return false;
    }

    private boolean hasNamespace(String uri) {
        return uri != null && !"".equals(uri);
    }

    protected boolean matchesNamespaceURIs(String u1, String u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null) {
            u1 = "";
        }
        if (u2 == null) {
            u2 = "";
        }
        return u1.equals(u2);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

