/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.dom4j.Dom4jXPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.util.SingleObjectIterator;

public class DocumentNavigator
extends DefaultNavigator {
    private transient SAXReader reader;

    public static Navigator getInstance() {
        return Singleton.instance;
    }

    public boolean isElement(Object obj) {
        return obj instanceof Element;
    }

    public boolean isComment(Object obj) {
        return obj instanceof Comment;
    }

    public boolean isText(Object obj) {
        return obj instanceof Text || obj instanceof CDATA;
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof Attribute;
    }

    public boolean isProcessingInstruction(Object obj) {
        return obj instanceof ProcessingInstruction;
    }

    public boolean isDocument(Object obj) {
        return obj instanceof Document;
    }

    public boolean isNamespace(Object obj) {
        return obj instanceof Namespace;
    }

    public String getElementName(Object obj) {
        Element elem = (Element)obj;
        return elem.getName();
    }

    public String getElementNamespaceUri(Object obj) {
        Element elem = (Element)obj;
        String uri = elem.getNamespaceURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public String getElementQName(Object obj) {
        Element elem = (Element)obj;
        return elem.getQualifiedName();
    }

    public String getAttributeName(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getName();
    }

    public String getAttributeNamespaceUri(Object obj) {
        Attribute attr = (Attribute)obj;
        String uri = attr.getNamespaceURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public String getAttributeQName(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getQualifiedName();
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        if (contextNode instanceof Branch) {
            Branch node = (Branch)contextNode;
            return node.nodeIterator();
        }
        return null;
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        if (contextNode instanceof Document) {
            return new SingleObjectIterator(contextNode);
        }
        Node node = (Node)contextNode;
        Element parent = node.getParent();
        if (parent == null) {
            parent = node.getDocument();
        }
        return new SingleObjectIterator(parent);
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof Element)) {
            return null;
        }
        Element elem = (Element)contextNode;
        return elem.attributeIterator();
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        if (!(contextNode instanceof Element)) {
            return null;
        }
        Element element = (Element)contextNode;
        ArrayList<Node> nsList = new ArrayList<Node>();
        HashSet<String> prefixes = new HashSet<String>();
        Element context = element;
        while (context != null) {
            List declaredNS = context.declaredNamespaces();
            Iterator iter = declaredNS.iterator();
            while (iter.hasNext()) {
                Namespace namespace = (Namespace)iter.next();
                String prefix = namespace.getPrefix();
                if (prefixes.contains(prefix)) continue;
                prefixes.add(prefix);
                nsList.add(namespace.asXPathResult(element));
            }
            context = context.getParent();
        }
        nsList.add(Namespace.XML_NAMESPACE.asXPathResult(element));
        return nsList.iterator();
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof Document) {
            return contextNode;
        }
        if (contextNode instanceof Node) {
            Node node = (Node)contextNode;
            return node.getDocument();
        }
        return null;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new Dom4jXPath(xpath);
    }

    public Object getParentNode(Object contextNode) {
        if (contextNode instanceof Node) {
            Node node = (Node)contextNode;
            Element answer = node.getParent();
            if (answer == null && (answer = node.getDocument()) == null) {
                answer = node;
            }
            return answer;
        }
        return null;
    }

    public String getTextStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    public String getElementStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    public String getAttributeStringValue(Object obj) {
        return this.getNodeStringValue((Node)obj);
    }

    private String getNodeStringValue(Node node) {
        return node.getStringValue();
    }

    public String getNamespaceStringValue(Object obj) {
        Namespace ns = (Namespace)obj;
        return ns.getURI();
    }

    public String getNamespacePrefix(Object obj) {
        Namespace ns = (Namespace)obj;
        return ns.getPrefix();
    }

    public String getCommentStringValue(Object obj) {
        Comment cmt = (Comment)obj;
        return cmt.getText();
    }

    public String translateNamespacePrefixToUri(String prefix, Object context) {
        Namespace namespace;
        Element element = null;
        if (context instanceof Element) {
            element = (Element)context;
        } else if (context instanceof Node) {
            Node node = (Node)context;
            element = node.getParent();
        }
        if (element != null && (namespace = element.getNamespaceForPrefix(prefix)) != null) {
            return namespace.getURI();
        }
        return null;
    }

    public short getNodeType(Object node) {
        if (node instanceof Node) {
            return ((Node)node).getNodeType();
        }
        return 0;
    }

    public Object getDocument(String uri) throws FunctionCallException {
        try {
            return this.getSAXReader().read(uri);
        }
        catch (DocumentException e) {
            throw new FunctionCallException("Failed to parse document for URI: " + uri, (Exception)((Object)e));
        }
    }

    public String getProcessingInstructionTarget(Object obj) {
        ProcessingInstruction pi = (ProcessingInstruction)obj;
        return pi.getTarget();
    }

    public String getProcessingInstructionData(Object obj) {
        ProcessingInstruction pi = (ProcessingInstruction)obj;
        return pi.getText();
    }

    public SAXReader getSAXReader() {
        if (this.reader == null) {
            this.reader = new SAXReader();
            this.reader.setMergeAdjacentText(true);
        }
        return this.reader;
    }

    public void setSAXReader(SAXReader reader) {
        this.reader = reader;
    }

    private static class Singleton {
        private static DocumentNavigator instance = new DocumentNavigator();

        private Singleton() {
        }
    }
}

