/*

   Scan.C -- This file has the main methods you will need to 
   fill in for this assignment.
*/


// system includes
#include <stdio.h>
#include <math.h>

// local includes
#include "SCtypes.h"
#include "Interface.h"
#include "Polygon.h"
#include "Edge.h"
#include "EdgeRec.h"
#include "EdgeRecList.h"
#include "Scan.h"


// useful color defs
static Color cwhite = Color (1.0, 1.0, 1.0);
static Color clgrey = Color (0.75, 0.75, 0.75);
static Color cmgrey = Color (0.5, 0.5, 0.5);
static Color cdgrey = Color (0.25, 0.25, 0.25);
static Color cblack = Color (0.0, 0.0, 0.0);



// Comment:  This is called back *once* after the series of
//           calls to EdgeRec::Init() (see above).
// Effect: Renders scanlines for y = (0..yres-1), using setPixel()
//         with the correct color for each <x, y> pixel
// Modifies: env->EdgeRecTable
// Requires: env, properly initialized [see EdgeRec::Init()]
// TASK: complete this procedure to create, maintain, destroy AEL
//         and make the appropriate set of calls to setPixel()
void RenderScene (Environment *env, 
		  void setPixel(int x, int y, Color color, Environment *env))
{

  //  Remove the following line before entering your own code further down.
  //printf("Entering RenderScene.  You should fill this subroutine in. \n");
  // Steps:
  // 
  // 1) Allocate AEL
  // 2) for each y
  //      2a) Maintain AEL by calling Concat() with
  //          current bucket from env->EdgeRecTable
  //      2b) Sort AEL entries using AEL.Sort()
  //      2c) Call RenderScanLine()
  //      2d) Update AEL using AEL.Update()

  // allocate AEL
  // see?  We give you code...
  EdgeRecList *AEL = new EdgeRecList();

  // loop over all scanlines
  // Notice that we are scan-converting from bottom (0) to top (wvpSize[Y]).
  for (int line = 0; line < env->wvpSize[Y]; line++) {

    // Happy debugging
    if (interface::debug) fprintf (stderr, "Scan Line %4d\n", line);
    
        // incorporate starting or ending edges and then sort
    AEL->Concat(&(env->EdgeRecTable[line]));
    

    // sort active AEL by current X value
    AEL->Sort();
    // output active spans to this raster
    RenderScanLine(line, env, AEL, setPixel);
    // remove completed edges from AEL
    // update vertical parameters
    AEL->Update(line);
  }                                                        

  // clean up your trash.
  delete(AEL);

} // end RenderScene




// Requires: EdgeRecList *AEL, which is the current List of active EdgeRec's.
//           AEL has all EdgeRecs that are valid for this scanline <line>
// Effect:   This routine renders one scan line, using setPixel() to set 
//           the color for each pixel. 
// Modifies: env->pixelData through calls to setPixel()
// TASK: complete this procedure (see comments below)
static void RenderScanLine (int line,
			    Environment *env,
			    EdgeRecList *AEL,
	     void setPixel (int x, int y, Color color, Environment *env))
{
  // Note:
  // Remember that the coordinates you have received are in eye coordinates
  // What does this mean for the z values?
  // Do x, z, col, h get linearly interpolated
  // Hint: What kind of projection has been applied to obtain the 
  //       screen space coordinates.

  //printf("rendering line %d\n", line);

  Color background = cdgrey;   // different from the open gl background color
  int xres = env->wvpSize[X];  // The width of the entire scan line



  // Method:
  //     Given the xcurr-sorted AEL, go through and find edges
  //     For each edge:
  //        if it ends a span for a specific polygon, stop rendering
  //        pixels for that polygon
  //        if it begins a span, find its mate (which should be later
  //        in the AEL--use NextPolyEdge, perhaps) and start rendering
  //        pixels for that polygon.
  //        Note: you could have a line buffer representing the scan
  //             line, and render the entire span when you find it.  This
  //             could reduce bookkeeping for you.  This would require an
  //             xres long array of z-values (or h-values) and another 
  //             array of color values.
  //             This gives a loop like:
  //                 initialize two buffers, color to background color, and
  //                 z-buffer to large value (i.e. infinity, so all polys
  //                 are closer than the background.)
  //                 go through AEL, and for each edge
  //                   if it is beginning a span, render span to buffer
  //                   (recording z-values so the closest span is recorded).
  //                   if it is a ending, do nothing.
  //                 write out buffer to screen.
  
  Color *colorbuf = (Color*)malloc(xres*sizeof(Color));
  //Color colorbuf[] = new Color[xres];
  float *Zbuf = (float*)malloc(xres*sizeof(float));

  for (int i = 0; i < xres; i++) {
    *(colorbuf + i) = background;
    *(Zbuf + i) = -MAXFLOAT;
  }

  
  EdgeRec *edge_rec1, *edge_rec2;
  edge_rec1 = AEL->ToFront();

  while (edge_rec1 != NULL) {

    //printf("looking at edge starting at (%f, %f)\n", edge_rec1->xstart,
    //   edge_rec1->ystart);

    edge_rec2 = AEL->NextPolyEdge(edge_rec1->poly);
    if (edge_rec2 != NULL) {
      float currentx, endx;
      currentx = ceil(edge_rec1->xcurr - 0.5) + .5;
      endx = floor(edge_rec2->xcurr + .5) - .5;
      Color dxcol = (edge_rec1->colcurr - edge_rec2->colcurr) / (edge_rec1->xcurr - edge_rec2->xcurr);
      Color currentcol = edge_rec1->colcurr + (currentx - edge_rec1->xcurr)*dxcol;
      Color endcol = edge_rec2->colcurr + (endx - edge_rec2->xcurr)*dxcol;
      float dxh = (edge_rec1->hcurr - edge_rec2->hcurr) /(edge_rec1->xcurr - edge_rec2->xcurr);
      float currenth = edge_rec1->hcurr + (currentx - edge_rec1->xcurr)*dxh;
      float endh = edge_rec2->hcurr + (endx - edge_rec2->xcurr)*dxh;
      
      while (currentx <= endx) {
	if (*(Zbuf + ((int)currentx)) < 1/currenth) {
	  *(Zbuf + ((int)currentx)) = 1/currenth;
	  *(colorbuf + ((int)currentx)) = currentcol;
	}
	currentx += 1;
	currentcol += dxcol;
	currenth +=dxh;
      }
    }
    edge_rec1 = AEL->Next();
  }

  for (i = 0; i < xres; i++) {
    setPixel(i, line, *(colorbuf + i), env);
  }
  
  // Go through the edge list, and for each edge
    // if not already scan converting this poly  
      // Fiddle with the edge's polygon's 'in' flag.

      // find the end for this span (i.e. the next edge belonging
      // to the same polygon in the list.


	
	

    // else we have finished a span



} // end RenderScanLine
















