/*
  EdgeRecList.C

  Luke Weisman
*/

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include "SCtypes.h"
#include "Utils.h"
#include "Scan.h"
#include "Interface.h"
#include "Edge.h"
#include "EdgeRec.h"
#include "EdgeRecList.h"


// Effect: Prints the EdgeRec List
//         Useful for debugging 
// Modifies: none.
// Requires: 
void EdgeRecList::PrintList ()
{
  CObject<EdgeRec> *p;
  int i = 0;
  EdgeRec *se;

  
  for( p = begin; p != NULL; p = p->GetNext() )
    {
      printf( "%d ", ++i );
      se = p->GetObject();
      if ( p == current )
	printf( "*" );
      se->Print();
    }

}




// Effect: Sorts the EdgeRecList pointed to by head
//         Sort is done on the xcurr, 
//         If xcurr is the same, the EdgeRec that is closer
//         is put ahead. If zcurr is the same,
//         the SpanEdge whose zend is closer zend is closer to the eye is put
//         ahead
// Modifies: potentially *head can be changed
// Requires: 
void EdgeRecList::Sort ()
{
// Implementation: 
//         Does not reallocate space for EdgeRecListNode.
//         Uses an array of pointers to EdgeRecListNode elements
//         and sorts the <sort key, array elem> using quicksort

  if ( Empty() ) return;

  // count elements on list
  int cnt = 1;
  ToFront();
  while ( Next() != NULL )
    cnt++;

  // make fixed array.
  EdgeRec ** SortElems = new EdgeRec*[cnt];
  assert (SortElems);
  
  // generate unsorted array from linked list
  EdgeRec *n = ToFront();
  for (int i = 0; i < cnt; i++) {
    assert (n);
    SortElems[i] = n;
    n = Next();
  }

  // sort the array in place
  //  qsort (&SortElems[0], cnt, sizeof (EdgeRec *), 
  //	 (int (*) (const void *, const void *)) EdgeRec::Compare);

  // qsort is being fussy, so we do a (horrid, horrid) bubble sort.
  int p, q;
  EdgeRec *temp;
  for (p=0; p < cnt-1; p++)
    for (q=p+1; q < cnt; q++)
      if ( EdgeRec::Compare(SortElems[p], SortElems[q]) > 0)
	{
	  temp = SortElems[p];
	  SortElems[p] = SortElems[q];
	  SortElems[q] = temp;
	}

  // regenerate linked list from sorted array
  Clear();
  for (i = 0; i < cnt; i++)
    Add( SortElems[i] );

  // free temp space
  delete [] SortElems;
}



// Requires: (this) pointing to current list of EdgeRecListNodes
// Modifies: head
// Effects:  Updates all edges of AEL in preparation for the next 
//           raster, then removes those that ended at this raster.
// TASK: complete this procedure
void EdgeRecList::Update (int line)
{
  // for each edge
      // if edge will end at next raster, remove it from list
      // else update
  EdgeRec *edge_rec1;
  edge_rec1 = ToFront();
  while (edge_rec1 != NULL) {
    if ((edge_rec1->yend-1) < line) {
      edge_rec1 = Remove();
    }
    else {
      edge_rec1->Update();
      edge_rec1 = Next();
    }
  }
} // end Update


// Requires:  a polygon with edges on this list after current
// Modifies:  nothing
// Effects:  returns the first edge owned by the polygon poly after current
EdgeRec * EdgeRecList::NextPolyEdge (Polygon * poly)
{
  if (current == NULL)
    return NULL;
	       
  CObject<EdgeRec> *p=current->GetNext();
 
  if (p == NULL)
    return NULL;
  //assert(p != NULL);

  while ((p != NULL) && (p->GetObject()->poly != poly))
      p = p->GetNext();

  if (p == NULL)
    return NULL;
  //assert (p != NULL);
  return p->GetObject();
}













