/*
   EdgeRec.C

   The flesh of the EdgeRec class.
*/

#include <stdlib.h>
#include <stdio.h>
#include "SCtypes.h"
#include "Utils.h"
#include "Scan.h"
#include "Interface.h"
#include "Edge.h"
#include "EdgeRec.h"
#include "EdgeRecList.h"

// General constructor.  Set all fields to 0.
EdgeRec::EdgeRec () 
  {
    ystart = yend = ycurr = 0.;
    xstart = xend = xcurr = dx = 0.;
    zstart = zend = zcurr = dz = 0.;
    hstart = hend = hcurr = dh = 0.;
    nstart = nend = ncurr = dn = Vector (0., 0., 0.);
    colcurr = dcol = Color (0., 0., 0.);
    edge = NULL;
    poly = NULL;
  }


// Comment:  Upon the press of any ScanConvert button, this routine 
// will be called once per polygon edge (that is, three times for
// each triangle that survives clipping).
//
// Requires: Edge *pedge set up with ss, es, col associated with its vertices
// Effect: Sets up the EdgeRec with information from the edge
//         This procedure should set up ystart, yend, xstart, xend
//         etc. correctly. 
// Modifies: The "this" object (i.e., the EdgeRec to be initialized).
// TASK:  Complete the procedure so that it initializes EdgeRec.

void EdgeRec::Init (Edge *pedge)
{

  // The following line is provided for debugging.  You should remove it before turning in your code.
  //printf("Entering EdgeRec::Init.  Edge = (%d, %d)-(%d, %d) \n",
  //        pedge->ss[0][X], pedge->ss[0][Y], pedge->ss[1][X],
  //        pedge->ss[1][Y]);

  //The components of an EdgeRec:
  //  (Things you might want to initialize and later use.)

  // screen-space vertices
  // world-space vertices
  // color at each vertex
  // optional normal at each vertex

  //initial edge values:
  float init_ystart = pedge->ss[0][Y];
  float init_yend = pedge->ss[1][Y];
  float init_xstart = pedge->ss[0][X];
  float init_xend = pedge->ss[1][X];
  dx = (init_xend - init_xstart) / (init_yend - init_ystart);
  Color init_colstart = pedge->col[0];
  Color init_colend = pedge->col[1];
  dcol = (init_colend - init_colstart) / (init_yend - init_ystart);

  // set up y
  if((init_ystart - floor(init_ystart)) < 0.5) {
    ystart = floor(init_ystart) +.5;
    }
  else {
      ystart = ceil(init_ystart) + .5;
  }

  if ((init_yend - floor(init_yend)) <= .5) {
    yend = floor(init_yend) - .5;
  }
  else {
    yend = ceil(init_yend) -.5;
  }
  ycurr = ystart;

  // set up x
  xstart = init_xstart + (ystart - init_ystart)*dx;
  xend = init_xend + (yend - init_yend)*dx;
  xcurr = xstart;


  // set up color  
  colstart = init_colstart + (ystart - init_ystart)*dcol;
  colend = init_colend + (yend - init_yend)*dcol; 
  colcurr = colstart;

  // set up depth
  zstart = pedge->es[0][Z]; 
  zend = pedge->es[1][Z];
  dz = (zend - zstart) / (yend - ystart);
  zcurr = zstart;

  // initialize edge, poly fields
  
  edge = pedge;
  poly = pedge->poly;

  // set up inverse depth
  float init_hstart = 1/zstart;
  float init_hend = 1/zend;
  dh = (init_hend - init_hstart) / (init_yend - init_ystart);
  hstart = init_hstart + (ystart - init_ystart)*dh;
  hend = init_hend + (yend - init_yend)*dh;
  hcurr = hstart;

  // Optional set up normals
  

  // set up deltas as necessary


}





// Requires: EdgeRec with correct delta information
// Effect: Updates EdgeRec in preparation for the next scanline. 
//         Should update xcurr, ycurr, color, etc. appropriately
// Modifies: ???
// TASK: complete this procedure
void EdgeRec::Update ()
{
  // Update the edgerec fields to correspond to the next scan-line.
  ycurr += 1;
  xcurr += dx;
  colcurr += dcol;
  hcurr += dh;

}

// Requires: none
// Effect: print out edge to screen.
// Modifies: none
void EdgeRec::Print()
{
    printf ("se ystart %f yend %f ycurr %f xstart %f xend %f xcurr %f poly %p\n",
	    ystart, yend, ycurr, xstart, xend, xcurr, poly);
    printf ("   st color = %f %f %f   end color = %f %f %f dc = %f %f %f\n",
	    colstart[0], colstart[1], colstart[2], 
	    colend[0], colend[1], colend[2],
	    dcol[0], dcol[1], dcol[2] );
}


// Effect: compares on basis of xcurr, the current xvalue, as computed
//         last.
//         Return -1 if elem1 < elem2, return 1 if elem1 > elem2
//         return 0 if elem1 == elem2
// Modifies: None
int EdgeRec::Compare ( EdgeRec *a, EdgeRec *b )
{
  assert(a != NULL);
  assert(b != NULL);
 
  // compare x values of this and b.
  if ( a->xcurr < b->xcurr) return -1;   // a is less
  if ( a->xcurr > b->xcurr) return 1;     // a is more
  else return 0;                       // a and b are equal
}
