/*

   Scan.C -- This file has the main methods you will need to 
   fill in for this assignment.
*/


// system includes
#include <stdio.h>
#include <math.h>

// local includes
#include "SCtypes.h"
#include "Interface.h"
#include "Polygon.h"
#include "Edge.h"
#include "EdgeRec.h"
#include "EdgeRecList.h"
#include "Scan.h"


// useful color defs
static Color cwhite = Color (1.0, 1.0, 1.0);
static Color clgrey = Color (0.75, 0.75, 0.75);
static Color cmgrey = Color (0.5, 0.5, 0.5);
static Color cdgrey = Color (0.25, 0.25, 0.25);
static Color cblack = Color (0.0, 0.0, 0.0);



// Comment:  This is called back *once* after the series of
//           calls to EdgeRec::Init() (see above).
// Effect: Renders scanlines for y = (0..yres-1), using setPixel()
//         with the correct color for each <x, y> pixel
// Modifies: env->EdgeRecTable
// Requires: env, properly initialized [see EdgeRec::Init()]
// TASK: complete this procedure to create, maintain, destroy AEL
//         and make the appropriate set of calls to setPixel()
void RenderScene (Environment *env, 
		  void setPixel(int x, int y, Color color, Environment *env))
{

  //  Remove the following line before entering your own code further down.
  // Steps:
  // 
  // 1) Allocate AEL
  // 2) for each y
  //      2a) Maintain AEL by calling Concat() with
  //          current bucket from env->EdgeRecTable
  //      2b) Sort AEL entries using AEL.Sort()
  //      2c) Call RenderScanLine()
  //      2d) Update AEL using AEL.Update()

  // allocate AEL
  // see?  We give you code...
  EdgeRecList *AEL = new EdgeRecList();
  EdgeRec *ptr;
  // loop over all scanlines
  // Notice that we are scan-converting from bottom (0) to top (wvpSize[Y]).
  for (int line = 0; line < env->wvpSize[Y]; line++) 
    {

      if (interface::debug) fprintf (stderr, "Scan Line %4d\n", line);

      // Add the line segments that start at a certain coordinate.
      ptr=env->EdgeRecTable[line].ToFront();
      while(ptr!=NULL)
	{
	  AEL->Add(ptr);
	  ptr=env->EdgeRecTable[line].Next();
	}

      // sort active AEL by current X value
      AEL->Sort();

      
      // output active spans to this raster
      RenderScanLine(line,env,AEL,setPixel);

      // This is a little counter intuitive, but it seems to work :)
      AEL->Update(line+1);      

      // remove completed edges from AEL
      // Let update do this.
      // update vertical parameters ??
      // Once again, let update do this, your already in the damn list!
    }                                                        
  
  // clean up your trash.
  delete AEL; // Delete is not a method damnit!
  
} // end RenderScene




// Requires: EdgeRecList *AEL, which is the current List of active EdgeRec's.
//           AEL has all EdgeRecs that are valid for this scanline <line>
// Effect:   This routine renders one scan line, using setPixel() to set 
//           the color for each pixel. 
// Modifies: env->pixelData through calls to setPixel()
// TASK: complete this procedure (see comments below)
static void RenderScanLine (int line,
			    Environment *env,
			    EdgeRecList *AEL,
	     void setPixel (int x, int y, Color color, Environment *env))
{
  // Note:
  // Remember that the coordinates you have received are in eye coordinates
  // What does this mean for the z values?
  // Do x, z, col, h get linearly interpolated
  // Hint: What kind of projection has been applied to obtain the 
  //       screen space coordinates.

  Color background = cdgrey;   // different from the open gl background color
  int xres = env->wvpSize[X];  // The width of the entire scan line
  Color *screen_line = new Color[xres];
  float *z_buffer = new float[xres];
  EdgeRec *ptr;
  EdgeRec *other_edge;
  float x;
  int i;
  double r, g, b;
  double dr, dg, db;
  float dz,z;
  // Method:
  //     Given the xcurr-sorted AEL, go through and find edges
  //     For each edge:
  //        if it ends a span for a specific polygon, stop rendering
  //        pixels for that polygon
  //        if it begins a span, find its mate (which should be later
  //        in the AEL--use NextPolyEdge, perhaps) and start rendering
  //        pixels for that polygon.
  //        Note: you could have a line buffer representing the scan

  //             line, and render the entire span when you find it.  This
  //             could reduce bookkeeping for you.  This would require an
  //             xres long array of z-values (or h-values) and another 
  //             array of color values.
  //             This gives a loop like:
  //                 initialize two buffers, color to background color, and
  //                 z-buffer to large value (i.e. infinity, so all polys
  //                 are closer than the background.)
  //                 go through AEL, and for each edge
  //                   if it is beginning a span, render span to buffer
  //                   (recording z-values so the closest span is recorded).
  //                   if it is a ending, do nothing.
  //                 write out buffer to screen.

  // Doing this as a mini Z Buffer is easy and cute ;)

  // Go through the edge list, and for each edge
    // if not already scan converting this poly  
      // Fiddle with the edge's polygon's 'in' flag.

      // find the end for this span (i.e. the next edge belonging
      // to the same polygon in the list.
  // Note the "NextPolyEdgeRoutine".
  ptr=AEL->ToFront();

  for(i=0;i<xres;i++)
    {
      z_buffer[i] = HUGE;
      screen_line[i] = background;
    }

  while(ptr!=NULL)
    {
      if(ptr->poly->in==TRUE)
	{
	  ptr->poly->in=FALSE;
	} else {
	  ptr->poly->in=TRUE;

	  other_edge=AEL->NextPolyEdge(ptr->poly);
	  assert(other_edge);

	  r = ptr->colcurr[0];
	  g = ptr->colcurr[1];
	  b = ptr->colcurr[2];
	  z = ptr->zcurr;
	  // Center X.
	  x = floor(ptr->xcurr+0.5)+0.5;
	  dz = (ptr->zcurr - other_edge->zcurr)/(ptr->xcurr-other_edge->xcurr);
	  // Deal with the centering of X.
	  z += (x-ptr->xcurr)*dz;
	  dr = (ptr->colcurr[0] - other_edge->colcurr[0])/(ptr->xcurr-other_edge->xcurr);
	  r += (x-ptr->xcurr)*dr;
	  dg = (ptr->colcurr[1] - other_edge->colcurr[1])/(ptr->xcurr-other_edge->xcurr);
	  g += (x-ptr->xcurr)*dg;
	  db = (ptr->colcurr[2] - other_edge->colcurr[2])/(ptr->xcurr-other_edge->xcurr);
	  b += (x-ptr->xcurr)*db;
	  // The -0.5 is needed otherwise you can over-scan :(
	  // The assertions below caught that when I was seeing some
	  // visual artifacts.
	  for(i=x;i<=(other_edge->xcurr-0.5);i++)
	    {
	      assert(r>=0.0&&r<=1.0);
	      assert(g>=0.0&&g<=1.0);
	      assert(b>=0.0&&b<=1.0);
	      if(z<z_buffer[i])
		{
		  screen_line[i][0] = r;
		  screen_line[i][1] = g;
		  screen_line[i][2] = b;
		  z_buffer[i] = z;
		}
	      r+=dr;
	      g+=dg;
	      b+=db;
	      z+=dz;
	    }
	}
      ptr=AEL->Next();
    }

	
  // This blit's to the screen.
  for(i=0;i<xres;i++)
    {
      setPixel(i,line,screen_line[i],env);
    }

  // we have finished a span
  delete [] z_buffer;
  delete [] screen_line;

} // end RenderScanLine














