
/*
   EdgeRec.C

   The flesh of the EdgeRec class.
*/

#include <stdlib.h>
#include <stdio.h>
#include "SCtypes.h"
#include "Utils.h"
#include "Scan.h"
#include "Interface.h"
#include "Edge.h"
#include "EdgeRec.h"
#include "EdgeRecList.h"

// General constructor.  Set all fields to 0.
EdgeRec::EdgeRec () 
  {
    ystart = yend = ycurr = 0.;
    xstart = xend = xcurr = dx = 0.;
    zstart = zend = zcurr = dz = 0.;
    colcurr = dcol = Color (0., 0., 0.);
    edge = NULL;
    poly = NULL;
  }


// Comment:  Upon the press of any ScanConvert button, this routine 
// will be called once per polygon edge (that is, three times for
// each triangle that survives clipping).
//
// Requires: Edge *pedge set up with ss, es, col associated with its vertices
// Effect: Sets up the EdgeRec with information from the edge
//         This procedure should set up ystart, yend, xstart, xend
//         etc. correctly. 
// Modifies: The "this" object (i.e., the EdgeRec to be initialized).
// TASK:  Complete the procedure so that it initializes EdgeRec.


void EdgeRec::Init (Edge *pedge,Environment *env)
{

  //The components of an EdgeRec:
  //  (Things you might want to initialize and later use.)

  // initialize edge, poly fields

  edge = pedge; // I wish I had a reference count. :(
  
  poly = pedge->poly; // Not strictly needed but nice.

  // screen-space vertices
  // you might need to sort this based on the Y Cooridinates, not sure.

  //  xstart = ((pedge->ss[0][X]+1.0)/2.0)*width;
  //  ystart = ((pedge->ss[0][Y]+1.0)/2.0)*height;
  xstart =  pedge->ss[0][0];
  ystart =  pedge->ss[0][1];

  //  xend = ((pedge->ss[1][X]+1.0)/2.0)*width;
  //  yend = ((pedge->ss[1][Y]+1.0)/2.0)*height;

  //  xend = pedge->ss[1][X];
  // yend = pedge->ss[1][Y];
  xend = pedge->ss[1][0];
  yend = pedge->ss[1][1];

  dx = (xstart-xend) / (ystart-yend);

  // world-space vertices
  // These can be re-derived from the above if needed.

  // color at each vertex
  // Set the color to white once you know what is going on until your done 
  // debugging
  // optional normal at each vertex
  // Not real likely, I'd rather do per-surface normals, it's easier.

  // set up y
  ycurr = floor(ystart+0.5)+0.5;

  // set up x
  xcurr = dx*(ycurr-ystart)+xstart;

  // set up color  XXX - Do this once you have color working.

  // set up depth

  // This was derived from the notes, and some judicious use of Maple.
  // (Maple is a symbolic mathematics package)

  zstart = ((env->viewVolume.farDistance+env->viewVolume.nearDistance)/
    (env->viewVolume.farDistance-env->viewVolume.nearDistance) +
    (2.0*(env->viewVolume.farDistance*env->viewVolume.nearDistance)/(
    (env->viewVolume.farDistance-env->viewVolume.nearDistance)*
    pedge->es[0][Z])));

  zend = ((env->viewVolume.farDistance+env->viewVolume.nearDistance)/
    (env->viewVolume.farDistance-env->viewVolume.nearDistance) + 
    (2.0*(env->viewVolume.farDistance*env->viewVolume.nearDistance)/(
    (env->viewVolume.farDistance-env->viewVolume.nearDistance)*
    pedge->es[1][Z])));

  
  // This is geometrically derivable.
  dz = (zstart - zend) / (ystart - yend);
  zcurr = dz*(ycurr-ystart)+zstart;

  // Colors :)
  colstart = pedge->col[0];
  colend = pedge->col[1];
  colcurr = pedge->col[0];

  dcol[0] = (pedge->col[0][0] - pedge->col[1][0])/(ystart - yend);
  dcol[1] = (pedge->col[0][1] - pedge->col[1][1])/(ystart - yend);
  dcol[2] = (pedge->col[0][2] - pedge->col[1][2])/(ystart - yend);
}





// Requires: EdgeRec with correct delta information
// Effect: Updates EdgeRec in preparation for the next scanline. 
//         Should update xcurr, ycurr, color, etc. appropriately
// Modifies: ???
// TASK: complete this procedure
void EdgeRec::Update ()
{
  xcurr += dx;
  ycurr += 1.0;
  zcurr += dz;
  
  colcurr[0] += dcol[0];
  colcurr[1] += dcol[1];
  colcurr[2] += dcol[2];
}

// Requires: none
// Effect: print out edge to screen.
// Modifies: none
void EdgeRec::Print()
{
    printf ("se ystart %f yend %f ycurr %f xstart %f xend %f xcurr %f poly %p\n",
	    ystart, yend, ycurr, xstart, xend, xcurr, poly);
    printf ("   st color = %f %f %f   end color = %f %f %f dc = %f %f %f\n",
	    colstart[0], colstart[1], colstart[2], 
	    colend[0], colend[1], colend[2],
	    dcol[0], dcol[1], dcol[2] );
}


// Effect: compares on basis of xcurr, the current xvalue, as computed
//         last.
//         Return -1 if elem1 < elem2, return 1 if elem1 > elem2
//         return 0 if elem1 == elem2
// Modifies: None
int EdgeRec::Compare ( EdgeRec *a, EdgeRec *b )
{
  assert(a != NULL);
  assert(b != NULL);
 
  // compare x values of this and b.
  if ( a->xcurr < b->xcurr) return -1;   // a is less
  if ( a->xcurr > b->xcurr) return 1;     // a is more
  else return 0;                       // a and b are equal
}
