import Drawable;
import java.awt.Color;

public class Vertex2D implements Drawable {
    public float x, y;              // coordinate of vertex
    public int argb;                // color of vertex
    
    public Vertex2D(float xval, float yval, int cval)
    {
        x = xval;
        y = yval;
        argb = cval;
    }
    
    public Color getColor()
    {
        return new Color(argb);
    }
    
    public void Draw(Raster r)
    {
        int ix = (int) (x + 0.5f);
        int iy = (int) (y + 0.5f);
        if ((ix < 0) || (ix >= r.width)) return;
        if ((iy < 0) || (iy >= r.height)) return;
        r.setPixel(argb, ix, iy);
    }
    
    public String toString()
    {
        return new String(Float.toString(x)+" "+Float.toString(y)+" 0x"+Integer.toHexString(argb));
    }
}