import Drawable;
import Vertex2D;

class Triangle implements Drawable {
    protected Vertex2D v[];

    public Triangle() {
    }

    public Triangle(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        v = new Vertex2D[3];
        v[0] = v0;
        v[1] = v1;
        v[2] = v2;
    }

    public void Draw(Raster r) 
      {

      //  First, find the top y-value and index
      float fTopY = v[0].y;
      int nTopIndex = 0;
      for(int i=1;i<3;i++)
	{
	  if(v[i].y<fTopY)
	    {
	      fTopY = v[i].y;
	      nTopIndex = i;
	    }
	}
      
      //  Find the lowest and middle points
      int nBottomIndex = nTopIndex + (nTopIndex==2?-2:1);
      int nMiddleIndex = nBottomIndex + (nBottomIndex==2?-2:1);
      if(v[nBottomIndex].y<v[nMiddleIndex].y)
	{
	  //  Switch them around
	  int temp = nBottomIndex;
	  nBottomIndex = nMiddleIndex;
	  nMiddleIndex = temp;
	}

      //  Find top to bottom line length, slope
      float fLongYLength = v[nBottomIndex].y - v[nTopIndex].y;
      float fLongSlope = (v[nBottomIndex].x - v[nTopIndex].x)/fLongYLength;

      //  Find top to middle line length, slope
      float fShortYLength = v[nMiddleIndex].y - v[nTopIndex].y;
      float fShortSlope = (v[nMiddleIndex].x - v[nTopIndex].x)/fShortYLength;

      //  For color shading, calculate area of triangle
      float A2 = (v[1].x * v[2].y - v[2].x * v[1].y) 
	       - (v[0].x * v[2].y - v[2].x * v[0].y) 
               + (v[0].x * v[1].y - v[1].x * v[0].y);

      //  Set up the boundary conditions.  Round to the nearest y scan line inside the triangle
      float fYStep = (float)((int)v[nTopIndex].y + 1.0f);

      //  Set up the x limits for the scan line, adjusting for the round off
      float fXStepLong = v[nTopIndex].x + fLongSlope * (fYStep - v[nTopIndex].y);
      float fXStepShort = v[nTopIndex].x + fShortSlope * (fYStep - v[nTopIndex].y);

      //  Iterate over top triangle
      while(fYStep <= v[nMiddleIndex].y)
	{
	  //  Find the scan line
	  int nYLine = (int)fYStep;

	  //  Which way am I drawing along the x direction?
	  float step = (fXStepLong<fXStepShort?1.0f:-1.0f);

	  //  Set up the line, starting at the long side
	  //  Round depending on which way its going (dont round if going left)
	  float fXStep = (float)((int)(fXStepLong + (step + 1.0f)/2.0f));
	  float fLimit = (fXStepShort - fXStepLong) * step;
	  float fCounter = (fXStep - fXStepLong) * step;

	  //  Draw the line
      	  while(fCounter <= fLimit)
	    {
	      //  Find the x coordinate
	      int nXLine = (int)fXStep;

	      //  Calculate the color for exactly where this pixel is
	      float S0 = v[1].x * v[2].y - v[2].x * v[1].y 
		      + (v[1].y - v[2].y) * (float)nXLine 
		      + (v[2].x - v[1].x) * (float)nYLine;

	      float S1 = v[2].x * v[0].y - v[0].x * v[2].y 
		      + (v[2].y - v[0].y) * (float)nXLine 
		      + (v[0].x - v[2].x) * (float)nYLine;

	      float S2 = v[0].x * v[1].y - v[1].x * v[0].y 
		      + (v[0].y - v[1].y) * (float)nXLine 
		      + (v[1].x - v[0].x) * (float)nYLine;

	      S0 /= A2;
	      S1 /= A2;
	      S2 /= A2;

	      int nA = (int)((double)((v[0].argb & 0xff000000)>>24)*S0
			   +  (double)((v[1].argb & 0xff000000)>>24)*S1
			   +  (double)((v[2].argb & 0xff000000)>>24)*S2);

	      int nR = (int)((double)((v[0].argb & 0x00ff0000)>>16)*S0
			   +  (double)((v[1].argb & 0x00ff0000)>>16)*S1
			   +  (double)((v[2].argb & 0x00ff0000)>>16)*S2);

	      int nG = (int)((double)((v[0].argb & 0x0000ff00)>>8)*S0
			   +  (double)((v[1].argb & 0x0000ff00)>>8)*S1
			   +  (double)((v[2].argb & 0x0000ff00)>>8)*S2);

	      int nB = (int)((double)((v[0].argb & 0x000000ff))*S0
			   +  (double)((v[1].argb & 0x000000ff))*S1
			   +  (double)((v[2].argb & 0x000000ff))*S2);

	      int nTotal = (nA<<24) | (nR<<16) | (nG<<8) | nB;

	      //  Set the pixel
	      r.setPixel(nTotal, nXLine, nYLine);

	      //  Step in the x direction
	      fXStep += step;

	      //  Increase the counter
	      fCounter += 1.0f;
	    }

	  //  Step a scan line
	  fYStep += 1.0f;

	  //  Step the long and short sides, points exactly at nYLine
	  fXStepLong += fLongSlope;
	  fXStepShort += fShortSlope;
	}

      //  Now over second triangle
      fShortYLength = v[nBottomIndex].y - v[nMiddleIndex].y;
      fShortSlope = (v[nBottomIndex].x - v[nMiddleIndex].x)/fShortYLength;
      fXStepShort = v[nMiddleIndex].x + fShortSlope * (fYStep - v[nMiddleIndex].y);
      while(fYStep <= v[nBottomIndex].y)
	{
	  //  Find the scan line
	  int nYLine = (int)fYStep;

	  //  Which way am I drawing
	  float step = (fXStepLong<fXStepShort?1.0f:-1.0f);

	  //  Set up the line
	  float fXStep = (float)((int)(fXStepLong + (step + 1.0f)/2.0f));
	  float fLimit = (fXStepShort - fXStepLong) * step;
	  float fCounter = (fXStep - fXStepLong) * step;

	  //  Draw the line
	  while(fCounter <= fLimit)
	    {
	      int nXLine = (int)fXStep;

	      //  Calculate the color for exactly where this pixel is
	      float S0 = v[1].x * v[2].y - v[2].x * v[1].y 
		      + (v[1].y - v[2].y) * (float)nXLine 
		      + (v[2].x - v[1].x) * (float)nYLine;

	      float S1 = v[2].x * v[0].y - v[0].x * v[2].y 
		      + (v[2].y - v[0].y) * (float)nXLine 
		      + (v[0].x - v[2].x) * (float)nYLine;

	      float S2 = v[0].x * v[1].y - v[1].x * v[0].y 
		      + (v[0].y - v[1].y) * (float)nXLine 
		      + (v[1].x - v[0].x) * (float)nYLine;

	      S0 /= A2;
	      S1 /= A2;
	      S2 /= A2;

	      int nA = (int)((double)((v[0].argb & 0xff000000)>>24)*S0
			   +  (double)((v[1].argb & 0xff000000)>>24)*S1
			   +  (double)((v[2].argb & 0xff000000)>>24)*S2);

	      int nR = (int)((double)((v[0].argb & 0x00ff0000)>>16)*S0
			   +  (double)((v[1].argb & 0x00ff0000)>>16)*S1
			   +  (double)((v[2].argb & 0x00ff0000)>>16)*S2);

	      int nG = (int)((double)((v[0].argb & 0x0000ff00)>>8)*S0
			   +  (double)((v[1].argb & 0x0000ff00)>>8)*S1
			   +  (double)((v[2].argb & 0x0000ff00)>>8)*S2);

	      int nB = (int)((double)((v[0].argb & 0x000000ff))*S0
			   +  (double)((v[1].argb & 0x000000ff))*S1
			   +  (double)((v[2].argb & 0x000000ff))*S2);

	      int nTotal = (nA<<24) | (nR<<16) | (nG<<8) | nB;

	      r.setPixel(nTotal, nXLine, nYLine);

	      fXStep += step;
	      fCounter += 1.0f;
	    }

	  //  Step a scan line
	  fYStep += 1.0f;

	  //  Step the long and short sides, points exactly at nYLine
	  fXStepLong += fLongSlope;
	  fXStepShort += fShortSlope;
	 }
    }
}


