import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import Point3D;
import Matrix3D;

public class mytest extends Applet {
    final static int CHUNKSIZE = 100;
    Raster raster;
    Image screen;
    Point3D vertList[];
    Point3D worldList[];
    Point3D tranList[];
    int vertices;
    Matrix3D view;
    Matrix3D model;

    float eyex, eyey, eyez;
    float lookatx, lookaty, lookatz;
    float upx, upy, upz;
    float fov;

  // The following variables are used in my program to grab the
  // input from the user
  

    Choice transChoice;
    String trans;
    Choice Zcoord;
    boolean zon;
    Choice pers;
    String pchoice;
    TextField ex, ey, ez, ax, ay, az, ux, uy, uz, left, right, bottom, top, near, far;
    Button reset;
  Label lex, ley, lez, lax, lay, laz, lux, luy, luz, lleft, lright, lbottom, ltop, lnear, lfar;
  
  //******************************************************************
  public void init( )
  {
    
    // initialize button
    reset = new Button("Reset & Run");
    
    //initialize Labels
    lex = new Label("eyex");
    ley = new Label("eyey");
    lez = new Label("eyez");
    lax = new Label("atx");
    lay = new Label("aty");
    laz = new Label("atz");
    lux = new Label("upx");
    luy = new Label("upy");
    luz = new Label("upz");
    lleft = new Label("left");
    lright = new Label("right");
    lbottom = new Label("bottom");
    ltop = new Label("top");
    lnear = new Label("near");
    lfar = new Label("far");
    
    //initialize transChoice
    transChoice = new Choice();
    transChoice.addItem("Rotate");
    transChoice.addItem("Scale");
    transChoice.addItem("Shear");
    transChoice.addItem("Translate");
    
    trans = new String("Rotate");
    Zcoord = new Choice();
    Zcoord.addItem("z off");
    Zcoord.addItem("z on");
    zon = false;
    pers = new Choice();
    pers.addItem("Pers");
    pers.addItem("Ortho");
    pchoice = new String("Pers");
    
    //Add the 2 pulldown menus to the applet
    this.add(transChoice);
    this.add(Zcoord);
    
    raster = new Raster(size().width, size().height);
    raster.fill(getBackground());
    screen = raster.toImage();
	eyex = 0;        eyey = 0;        eyez = -10;
        lookatx = 0;     lookaty = 0;     lookatz = 0;
        upx = 0;         upy = 1;         upz = 0;
        fov = 30;
	
        vertList = new Point3D[CHUNKSIZE];
        vertices = 0;
        String filename = getParameter("datafile");
        showStatus("Reading "+filename);
        InputStream is = null;
        try {
            is = new URL(getDocumentBase(), filename).openStream();
            ReadInput(is);
            is.close();
        } catch (IOException e) {
            showStatus("Error reading "+filename);
        }
	
        worldList = new Point3D[vertList.length];
        tranList = new Point3D[vertList.length];
        for (int i = 0; i < vertices; i++) {
            worldList[i] = new Point3D();
            tranList[i] = new Point3D();
        }
	view = new Matrix3D(raster);
        float t = (float) Math.sin(Math.PI*(fov/2)/180);
        float s = (t*size().height)/size().width;
	
        view.perspective(-t, t, -s, s, -1, -200);
	
	//initialize textfields
	left = new TextField(Float.toString(-t));
	right = new TextField(Float.toString(t));
	bottom = new TextField(Float.toString(-s));
	top = new TextField(Float.toString(s));
	near = new TextField("-1");
	far = new TextField("-200");
	

	//view.showMatrix();
        view.lookAt(eyex, eyey, eyez, lookatx, lookaty, lookatz, upx, upy, upz);
	//Initialize more textfields!
	ex = new TextField(Float.toString(eyex));
	ey = new TextField(Float.toString(eyey));
	ez = new TextField(Float.toString(eyez));
	ax = new TextField(Float.toString(lookatx));
	ay = new TextField(Float.toString(lookaty));
	az = new TextField(Float.toString(lookatz));
	ux = new TextField(Float.toString(upx));
	uy = new TextField(Float.toString(upy));
	uz = new TextField(Float.toString(upz));

	//add all the textfields and their corresponding labels
	this.add(lex);
	this.add(ex);
	this.add(ley);
	this.add(ey); 
	this.add(lez);
	this.add(ez);
	this.add(lax); 
	this.add(ax);
	this.add(lay);
	this.add(ay);
	this.add(laz);
	this.add(az);
	this.add(lux);
	this.add(ux);
	this.add(luy);
	this.add(uy);
	this.add(luz);
	this.add(uz);
	this.add(lleft);
	this.add(left);
	this.add(lright);
	this.add(right);
	this.add(lbottom);
	this.add(bottom);
	this.add(ltop);
	this.add(top); 
	this.add(lnear);
	this.add(near);
	this.add(lfar);
	this.add(far);
	this.add(reset);
	this.add(pers);
	

        model = new Matrix3D();
        long time = System.currentTimeMillis();
        model.transform(vertList, worldList, 0, vertices);
        view.transform(worldList, tranList, 0, vertices);
        DrawObject();
        time = System.currentTimeMillis() - time;
        showStatus("Time = "+time+" ms");
        //screen = raster.toImage(this);
	screen = raster.toImage();
    }
  //******************************************************************
    private double getNumber(StreamTokenizer st) throws IOException
    {
        if (st.nextToken() != StreamTokenizer.TT_NUMBER) {
            System.err.println("ERROR: line "+st.lineno()+": expected number");
            throw new IOException(st.toString());
        }
        return st.nval;
    }
  //******************************************************************
    public void ReadInput(InputStream is) throws IOException
    {
	    StreamTokenizer st = new StreamTokenizer(is);
    	st.commentChar('#');
        scan: while (true) {
	        switch (st.nextToken()) {
	          default:
		        break scan;
	          case StreamTokenizer.TT_WORD:
		        if (st.sval.equals("v")) {
		            float x = (float) getNumber(st);
		            float y = (float) getNumber(st);
		            float z = (float) getNumber(st);
		            if (vertices == vertList.length) {
		                Point3D newList[] = new Point3D[vertList.length+CHUNKSIZE];
                        System.arraycopy(vertList, 0, newList, 0, vertList.length);
		                vertList = newList;
		            }
		            vertList[vertices++] = new Point3D(x, y, z);
		        } else
			    if (st.sval.equals("eye")) {
                    eyex = (float) getNumber(st);
                    eyey = (float) getNumber(st);
		            eyez = (float) getNumber(st);
			    } else
			    if (st.sval.equals("look")) {
                    lookatx = (float) getNumber(st);
                    lookaty = (float) getNumber(st);
		            lookatz = (float) getNumber(st);
			    } else
			    if (st.sval.equals("up")) {
                    upx = (float) getNumber(st);
                    upy = (float) getNumber(st);
		            upz = (float) getNumber(st);
			    } else
			    if (st.sval.equals("fov")) {
                    fov = (float) getNumber(st);
			    } else {
                    System.err.println("ERROR: line "+st.lineno()+": unexpected token :"+st.sval);
                    break scan;
			    }
			    break;
	        }
	        if (vertices % 100 == 0) showStatus("vertices = " + vertices);
	    }
        is.close();
	    if (st.ttype != StreamTokenizer.TT_EOF) {
	        throw new IOException(st.toString());
	    }
	}
    //******************************************************************
    public void paint(Graphics g)
    {
        g.drawImage(screen, 0, 0, this);
    }
    //******************************************************************
    public void update(Graphics g)
    {
        paint(g);
    }

    float v0x, v0y, v0z, initx, inity, initz;
  //******************************************************************
  public boolean action(Event e, Object arg)
  {
    // This procedure checks to see what button/field is activated 
      

    // If the transformation choice is altered, reflect it in
    // the variable trans
    if (e.target == transChoice)
      trans = new String(arg.toString());
    else
      //Similarly, if the Zcoord menu is altered,
      //then change zon according
      if (e.target == Zcoord)
	{
	  String cont = new String(arg.toString());
	  if (cont.equals("z off"))
	    zon = false;
	  else
	    zon = true;
	}
      else
	//if the perspective menu is changed,
	//then change variable pchoice accordingly	
	if (e.target == pers)
	  pchoice = new String(arg.toString());
	else
	  //if the button reset is presssed, then grab the input
	  //from the fields and use them to create a new Matrix3D view
	  if (e.target == reset)
	    {
	      view = new Matrix3D(raster);
	      float l = (Float.valueOf(left.getText()).floatValue());
	      float r =  Float.valueOf(right.getText()).floatValue();
	      float b =  Float.valueOf(bottom.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float t =  Float.valueOf(top.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float n =  Float.valueOf(near.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float f =  Float.valueOf(far.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float eyex = Float.valueOf(ex.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float eyey = Float.valueOf(ey.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float eyez = Float.valueOf(ez.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float atx = Float.valueOf(ax.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float aty = Float.valueOf(ay.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float atz = Float.valueOf(az.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float upx = Float.valueOf(ux.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float upy = Float.valueOf(uy.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      float upz = Float.valueOf(uz.getText()).floatValue();
	      //System.out.println("WOOOO HOO!");
	      if (pchoice.equals("Pers"))
		view.perspective(l, r, b, t, n, f);
	      else
		view.orthographic(l*9, r*9, b*9, t*9, n*9, f*9);
	      view.lookAt(eyex, eyey, eyez, atx, aty, atz, upx, upy, upz);
	     
	      model.transform(vertList, worldList, 0, vertices);
	      view.transform(worldList, tranList, 0, vertices);
   
	      DrawObject();
	      screen = raster.toImage();
	      repaint();    
	    }
    return true;
  }
  
  //******************************************************************
  public boolean mouseDown(Event e, int x, int y)
    {
      if (e.metaDown()) {
            showStatus("Resetting model matrix");
            model.loadIdentity();
	    model.transform(vertList, worldList, 0, vertices);
	    view.transform(worldList, tranList, 0, vertices);
	    DrawObject();
        
	    screen = raster.toImage();
	    repaint();
	
      }
        v0x = (float) (x - (size().width / 2));
        v0y = (float) ((size().height / 2) - y);
        v0z = (float) size().width;
        float l0 = (float) (1 / Math.sqrt(v0x*v0x + v0y*v0y + v0z*v0z));
        v0x *= l0;
        v0y *= l0;
        v0z *= l0;
	initx = x;
	inity = y;
	return true;
    }
    //******************************************************************
    public boolean mouseDrag(Event e, int x, int y)
    {
        if (e.metaDown()) {
            showStatus("Resetting model matrix");
        } else {
	  // if the transformation needed is rotate, do what was 
	  // done earlier
	  if (trans.equals("Rotate"))
	    {
	      float v1x = (float) (x - (size().width / 2));
	      float v1y = (float) ((size().height / 2) - y);
	      float v1z = (float) size().width;
	      float l = (float) (1 / Math.sqrt(v1x*v1x + v1y*v1y + v1z*v1z));
	      v1x *= l;
	      v1y *= l;
	      v1z *= l;
	      
	      float ax = v0y*v1z - v0z*v1y;
	      float ay = v0z*v1x - v0x*v1z;
	      float az = v0x*v1y - v0y*v1x;
	      l = (float) Math.sqrt(ax*ax + ay*ay + az*az);
	      float theta = (float) Math.asin(l);
	      if (v0x*v1x + v0y*v1y + v0z*v1z < 0)
                theta += (float) Math.PI / 2;
	      
	      model.rotate(ax, ay, az, theta);
	      v0x = v1x;
	      v0y = v1y;
	      v0z = v1z;
	    }
	  else
	    // Scale if the transformation needed is scaling
	    if (trans.equals("Scale"))
	      {
		float scalex;
		float scaley;
		float scalez;
		if (zon)
		  {
		    scalex = 1;
		    scaley = 1;
		    scalez = 1 + (inity - y)/size().height;
		  }
		else
		  {
		    scalex = 1 + (x - initx)/size().width;
		    scaley = 1 + (inity - y)/size().height;
		    scalez = 1;
		  }
		Matrix3D temp = new Matrix3D();
		temp.scale(scalex, scaley, scalez);
		temp.compose(model);
		model = temp;
	      }
	  else
	    //Shear if the transformation needed is Shear
	    if (trans.equals("Shear"))
	      {
		float scalexy;
		float scalexz;
		float scaleyz;
		if (zon)
		  {
		    scalexy = 0;
		    scalexz = 0;
		    scaleyz = (inity - y)/size().height;
		  }
		else
		  {
		    scalexy = (x - initx)/size().width;
		    scalexz = (inity - y)/size().height;
		    scaleyz = 0;
		  }
		Matrix3D temp = new Matrix3D();
		temp.shear(scalexy, scalexz, scaleyz);
		temp.compose(model);
		model = temp;
	      }
		else
		  //Translate if the transformation needed is translate
		  if (trans.equals("Translate"))
		    {
		      float xtrans;
		      float ytrans;
		      float ztrans;
		      if (zon)
			{
			  ztrans = (inity - y)/size().height;
			  xtrans = 0;
			  ytrans = 0;
			}
		      else
			{
			  xtrans = (x - initx)/size().width;
			  ytrans = (inity - y)/size().height;
			  ztrans = 0;
			}
		      Matrix3D temp = new Matrix3D();
		      temp.translate(xtrans, ytrans, ztrans);
		      temp.compose(model);
		      model = temp;
		    }
	  model.transform(vertList, worldList, 0, vertices);
	  view.transform(worldList, tranList, 0, vertices);
	  DrawObject();
        }
        screen = raster.toImage();
	repaint();
        return true;
    }
    //******************************************************************
    void DrawObject()
    {
        int ix, iy;
        int w, h;
        w = raster.width;
        h = raster.height;
        raster.fill(getBackground());
        for (int i = 0; i < vertices; i++) {
            ix = (int) tranList[i].x;
            iy = (int) tranList[i].y;
            if (ix >= 0 && iy >= 0 && ix < w && iy < h)
                raster.setPixel(0xffa000a0, ix, iy);
        }
    }
}

	
