package ps1;

import Raster;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;

class Sprite extends Raster {
	private int RGBMask = 0x00FFFFFF;
	protected Background pointerToMyPlayfield;

	private Raster theSavedBackground;
	private int theTransparentColor;	//theTransparentColor is the transparent color 
	private Point theLocation;			//the location of this in parent coordinates
	private Raster cleanCopyOfSelf;
	private static int GUID = 0;
	private int myGUID;

	//----------------------------------- Constructors -----------------------------------
	public Sprite () {
		this(0, 0);
	}

	public Sprite (int w, int h) {
		super(0, 0);
		pointerToMyPlayfield = null;
		theSavedBackground = new Raster();
		setTransparentColor(0);
		theLocation = new Point(0, 0);
		
		cleanCopyOfSelf = new Raster(0, 0);	//double copy of self
		myGUID = GUID++;
	}

	public Sprite (Image sprite) {
		/**	Requires:	<sprite> is not null
			Modifies:	nothing
			Effects:	Creates a new Sprite <sprite> with transparency 0 at playfield
						location (0, 0)
		*/
		this(sprite, 0);
	}

	public Sprite (Image sprite, int transparentColor) {
		/**	Requires:	<sprite> is not null, <transparentColor> is >=0 and <= 2^32 - 1
			Modifies:	nothing
			Effects:	Creates a new Sprite <sprite> with transparency <transparentColor>
						at playfield location (0, 0)
		*/
		this(sprite, new Point(0, 0), transparentColor);
	}

	public Sprite (Image sprite, Point pt, int transparentColor) {
		/**	Requires:	<sprite> is not null, <transparentColor> is >=0 and <= 2^32 - 1,
						and <pt> is "valid"
			Modifies:	nothing
			Effects:	Creates a new Sprite <sprite> with transparency <transparentColor>
						at playfield location <pt>
		*/
		super(sprite);
		pointerToMyPlayfield = null;
		theSavedBackground = new Raster ();
		setTransparentColor(transparentColor);
		theLocation = pt;
		
		cleanCopyOfSelf = new Raster(this.getWidth(), this.getHeight());	//double copy of self

		for (int i = 0; i < this.getWidth() * this.getHeight(); i++)	//this is completely clean
			cleanCopyOfSelf.pixel[i] = this.pixel[i];
		myGUID = GUID++;
	}

	//-------------------------------------- Methods -------------------------------------
	synchronized public void draw (Background rasPlayField) {
		/**	Requires:	<rasPlayField> is not null
			Modifies:	<rasPlayField>
			Effects:	draws this on <rasPlayField> with transparency and clipping
		*/
		//bitblt this raster, clipped, to rasPlayField at getLocation(), & save BG.
		pointerToMyPlayfield = rasPlayField;
		bitblt(this, clip(rasPlayField), rasPlayField, getLocation(), true);
	}
	
	synchronized protected void bitblt (Raster fromRaster, Rectangle clippedRegion, Background toRaster, 
		Point toLocationOnRaster, boolean bSaveBG) {
				
		int x, y;
		Raster theCleanToRaster = toRaster.getCleanCopyOfSelf();
		int clippedWidth = clippedRegion.width;
		int clippedHeight = clippedRegion.height;
		int toRasterClippedFill = toRaster.getWidth() - clippedWidth;
		int fromRasterClippedFill = fromRaster.getWidth() - clippedWidth;
		this.theSavedBackground = new Raster(clippedWidth, clippedHeight);
		int currentPixelOnFromRaster = clippedRegion.x + clippedRegion.y * fromRaster.getWidth();
		int currentPixelOnSavedRaster = 0;

		int adjustedXPositionOnToRaster = (toLocationOnRaster.x < 0) ? 0 : toLocationOnRaster.x;
		int adjustedYPositionOnToRaster = (toLocationOnRaster.y < 0) ? 0 : toLocationOnRaster.y;
		int currentPixelOnToRaster = adjustedYPositionOnToRaster * toRaster.getWidth() + adjustedXPositionOnToRaster;

		if (bSaveBG) {
			if ((toLocationOnRaster.x > toRaster.getWidth()) || 
				(toLocationOnRaster.y > toRaster.getHeight()) ||
				((toLocationOnRaster.y + fromRaster.getHeight()) < 0) || 
				((toLocationOnRaster.x + fromRaster.getWidth()) < 0))
				return;	//this is an error and should never happen!

			for (y = 0; y < clippedHeight; y++) {
				for (x = 0; x <	clippedWidth; x++) {
					theSavedBackground.pixel[currentPixelOnSavedRaster] = 
						toRaster.pixel[currentPixelOnToRaster];
					//	theCleanToRaster.pixel[currentPixelOnToRaster];
						
					
					if ((fromRaster.pixel[currentPixelOnFromRaster] & RGBMask) != 
						(theTransparentColor & RGBMask))
						toRaster.pixel[currentPixelOnToRaster] = 
							fromRaster.pixel[currentPixelOnFromRaster];	// & RGBMask
					
					currentPixelOnSavedRaster++;
					currentPixelOnToRaster++;
					currentPixelOnFromRaster++;
				}
				currentPixelOnToRaster += toRasterClippedFill;
				currentPixelOnFromRaster += fromRasterClippedFill;
			}
		} else {
			for (y = 0; y < clippedHeight; y++) {
				for (x = 0; x <	clippedWidth; x++) {
					if ((fromRaster.pixel[currentPixelOnFromRaster] & RGBMask) != 
						(theTransparentColor & RGBMask))
						toRaster.pixel[currentPixelOnToRaster] = 
							fromRaster.pixel[currentPixelOnFromRaster];
					
					currentPixelOnToRaster++;
					currentPixelOnFromRaster++;
				}
				currentPixelOnToRaster += toRasterClippedFill;
				currentPixelOnFromRaster += fromRasterClippedFill;
			}
		}
	}

	synchronized protected Rectangle clip (Raster rasPlayField) {
		/**	Requires:	<rasPlayField> is not null
			Modifies:	nothing
			Effects:	returns a bounding rectangle that represents the portion of
						<this> that is inside of <rasPlayField>
		*/
		/*
				(0,0)
				+
				|
				|		PlayField
				|
				|
			+--<-TOP->---+
			|            |
			L   Sprite   R--------
			|            |
			+-<-BOTTOM->-+
		*/
		int thisWidth = this.getWidth();
		int thisHeight = this.getHeight();
		int left = theLocation.x;
		int top = theLocation.y;
		int right = left + thisWidth;
		int bottom = top + thisHeight;

		/*
		left = (left < 0) ? 
			(((-left) > thisWidth) ? thisWidth : -left) :	0;
		top = (top < 0) ?
			(((-top) > thisHeight) ? thisHeight : -top) : 0;

		right = (right > rasPlayField.getWidth()) ? 
			thisWidth - (right - rasPlayField.getWidth()) - left:
			thisWidth - left;
		bottom = (bottom > rasPlayField.getHeight()) ?
			thisHeight - (bottom - rasPlayField.getHeight()) - top:
			thisHeight - top;
		if (right < 0) right = 0;
		if (bottom < 0) bottom = 0;
		*/
		if (left < 0) {
			if ((-left) > thisWidth)
				left = thisWidth;
			else
				left = -left;
		} else
			left = 0;

		if (top < 0) {
			if ((-top) > thisHeight)
				top = thisHeight;
			else
				top = -top;
		} else
			top = 0;

		if (right > rasPlayField.getWidth()) {
			if ((right - rasPlayField.getWidth()) > thisWidth)
				right = 0;
			else
				right = thisWidth - (right - rasPlayField.getWidth()) - left;
		} else
			right = thisWidth - left;

		if (bottom > rasPlayField.getHeight()) {
			if ((bottom - rasPlayField.getHeight()) > thisHeight)
				bottom = 0;
			else
				bottom = thisHeight - (bottom - rasPlayField.getHeight()) - top;
			
		} else
			bottom = thisHeight - top;
		
		return (new Rectangle(left, top, right, bottom));
	}

	public void setTransparentColor (int transparentColor) {
		/**	Requires:	<transparentColor> is >=0 and <= 2^32 - 1
			Modifies:	this
			Effects:	sets the transparent color of this to <transparentColor>
		*/
		theTransparentColor = transparentColor;
	}

	public int getTransparentColor () {
		/**	Requires:	nothing
			Modifies:	nothing
			Effects:	returns the transparent color of this
		*/
		return (theTransparentColor);
	}

	public void setLocation (Point location) {
		/**	Requires:	<location> is not null
			Modifies:	this
			Effects:	sets the location of this to <location>
		*/

		bitblt(theSavedBackground, 
			new Rectangle(0, 0, theSavedBackground.getWidth(), 
				theSavedBackground.getHeight()),
			pointerToMyPlayfield, getLocation(), false);
		
		theLocation = location;
	}

	public Point getLocation () {
		/**	Requires:	nothing
			Modifies:	nothing
			Effects:	returns the location of this
		*/
		return (theLocation);
	}

	public boolean getTransparency (Point pt) 
		throws NoSpriteLocatableException {
		/**	Requires:	<pt> is specified in parent coordinates
			Modifies:	nothing
			Effects:	if <pt> is not located within <this>, throw NoSPriteLocatableException
						Else, return true if the pixel of <this> at <pt> is transparent, and
						false otherwise
		*/
		if ((pt.x >= 0) && (pt.x < width) &&
			(pt.y >= 0) && (pt.y < height))	//contains the point
			return ((getTransparentColor() & RGBMask) == (pixel[pt.y * width + pt.x] & RGBMask));
		throw new NoSpriteLocatableException();
	}

	public Raster getSavedBackground () {
		return (theSavedBackground);
	}

	public Raster getCleanCopyOfSelf () {
		return (cleanCopyOfSelf);
	}

	public int hashCode () {
		return (myGUID);
	}

	public boolean equal (Object o) {
		Sprite otherSprite = (Sprite)o;

		return (this.hashCode() == otherSprite.hashCode());
	}
}
