package ps1;

import java.util.Vector;
import java.awt.Rectangle;

class AnimatedSprite extends Sprite{
	private Vector theTracks;	//each element is an AnimationTrack
	private static int dx;	//Animation X step size
	private static int dy;	//Animation Y step size
	//private Sprite currentSprite;
	private int mSecBetweenFrames;

	private AnimationTrack theCurrentTrack;	//each element is a sprite
	private int theCurrentTrackIndex;

	//----------------------------------- Constructors -----------------------------------
	public AnimatedSprite () {
		super();

		theTracks = new Vector();
		dx = 25;
		dy = 25;
		//currentSprite = null;
		mSecBetweenFrames = 100;
		theCurrentTrack = new AnimationTrack();
		theCurrentTrackIndex = 0;
		//tick = new Thread(this);
		//started = false;
	}

	//-------------------------------------- Methods -------------------------------------
	synchronized public void selfAnimate () {
		Raster currentSpriteRaster = theCurrentTrack.currentFrame();

		if (currentSpriteRaster != null) {
			this.pixel = new int[currentSpriteRaster.getWidth() * currentSpriteRaster.getHeight()];
			for (int i = 0; i < currentSpriteRaster.getWidth() * currentSpriteRaster.getHeight(); i++)
				this.pixel[i] = currentSpriteRaster.pixel[i];

			//this.pixel = currentSpriteRaster.pixel;
			this.width = currentSpriteRaster.getWidth();
			this.height = currentSpriteRaster.getHeight();
	
			//bitblt(getSavedBackground(), clip(pointerToMyPlayfield), pointerToMyPlayfield, getLocation(), false);
			bitblt(currentSpriteRaster, clip(pointerToMyPlayfield), pointerToMyPlayfield, getLocation(), true);

			try {
				theCurrentTrack.nextFrame();
			} catch (InvalidFrameException e) {}	//if there are no frames in the track
		}
	}

	public void addFrame (Raster frameContent, int track, int frame) {
		/**	Requires:	<frameContent> is not null, <track> >= 0, <frame> >=0
			Modifies:	<this>
			Effects:	adds <frameContent> as the #<frame> animation frame for the 
						animation sequence track #<track>.
		*/
		if (track != theCurrentTrackIndex) {
			if (track >= theTracks.size()) {
				for (int i = (track - theTracks.size() + 1); i > 0; i--)
					theTracks.addElement(new AnimationTrack());
			}

			theCurrentTrack = (AnimationTrack)theTracks.elementAt(track);
		}
		
		if (theCurrentTrack.getTotalFrames() == 0) {
			//this.pixel = frameContent.pixel;
			this.pixel = new int[frameContent.getWidth() * frameContent.getHeight()];
			for (int i = 0; i < frameContent.getWidth() * frameContent.getHeight(); i++)
				this.pixel[i] = frameContent.pixel[i];

			this.width = frameContent.getWidth();
			this.height = frameContent.getHeight();
		}
		theCurrentTrack.addFrame(frameContent, frame);
	}

	public void addFrame (Sprite frameContent, int track) {
		/**	Requires:	<frameContent> is not null, <track> >= 0
			Modifies:	<this>
			Effects:	adds <frameContent> as the last animation frame for the 
						animation sequence track #<track>.
		*/
		addFrame(frameContent, track, theCurrentTrack.getTotalFrames());
	}

	public void addFrame (Sprite frameContent) {
		/**	Requires:	<frameContent> is not null
			Modifies:	<this>
			Effects:	adds <frameContent> as the last animation frame for the current
						animation sequence track.
		*/
		addFrame(frameContent, theCurrentTrackIndex);
	}
	
	public void nextFrame () {
		/**	Effects:	selects the next animation frame of the current track for <this>
		*/						
		try {
			theCurrentTrack.nextFrame();
		} catch (InvalidFrameException e) {}	//if there are no frames in the track
	}

	public void setTrack (int track) {
		//bounds check track
		theCurrentTrack = (AnimationTrack)theTracks.elementAt(track);
	}

	public void setDelay (int delay) {
		mSecBetweenFrames = delay;
	}
}
