package ps1;

import java.util.Vector;

class AnimationTrack {
	private int theTotalNumberOfFrames;
	private Vector theFrames;
	private int currentFrameIndex;	//the current index of the animation sequence. 0 based

	//----------------------------------- Constructors -----------------------------------
	public AnimationTrack () {
		theFrames = new Vector();
		currentFrameIndex = -1;
	}
	//-------------------------------------- Methods -------------------------------------
	public void addFrame (Raster frameContent, int frameNumber) {
		/**	Requires:	<frameNumber> >= 0 (0 based)
			Modifies:	<this>
			Effects:	adds animation frame <frameContent> and assigns it the sequence
						index <frameNumber>
		*/
		if (frameNumber >= theFrames.size()) {
			for (int i = (frameNumber - theFrames.size() + 1); i > 0; i--)
				theFrames.addElement(null);
		}

		theFrames.setElementAt(frameContent, frameNumber);
		theTotalNumberOfFrames++;
		if (currentFrameIndex == -1)
			currentFrameIndex = 0;
	}
	
	public void addFrame (Raster frameContent) {
		/**	Requires:	nothing
			Modifies:	<this>
			Effects:	adds animation frame <frameContent> and assigns it the current last
						animation sequence index
		*/
		addFrame(frameContent, theTotalNumberOfFrames++);
	}

	public Sprite currentFrame () {
		if (currentFrameIndex != -1)
			return ((Sprite)theFrames.elementAt(currentFrameIndex));
		return (null);	//or throw an exception
	}

	public Raster nextFrame ()
		throws InvalidFrameException {
		/**	Requires:	
			Modifies:	
			Effects:	cycles
		*/
		if (currentFrameIndex != -1) {	//there are valid frames in this track
			currentFrameIndex++;
			if (currentFrameIndex >= theTotalNumberOfFrames)
				currentFrameIndex = 0;
			return (Sprite)theFrames.elementAt(currentFrameIndex);
		}

		throw new InvalidFrameException();
	}

	public void deleteFrame (int frameNumber)
		throws InvalidFrameException {
		/**	Requires:	
			Modifies:	
			Effects:	
		*/
		if ((frameNumber < 0) || (frameNumber >= theTotalNumberOfFrames))
			throw new InvalidFrameException();
		
		theFrames.removeElementAt(frameNumber);
	}

	public void reset () {
		/**	Requires:	nothing
			Modifies:	<this>
			Effects:	resets the current track's animation squence to its initial state
	*/
		if (currentFrameIndex != -1)
			currentFrameIndex = 0;
	}

	public int getCurrentFrameNumber () {
		return (currentFrameIndex);
	}

	public int getTotalFrames () {
		return (theTotalNumberOfFrames);
	}
}

class InvalidFrameException extends Exception {
	public InvalidFrameException () {super();}
	public InvalidFrameException (String s) {super(s);}
}

