/* txreg.v
 *
 * Transmit Register with Enable and specifiable C and P delays
 *
 * This register simulates a transition window by making the output
 * x between C and P after the clock edge.
 *
 * Luis F. G. Sarmenta 950514.2208
 *
 */

module txreg( q, clk, d, en );

   parameter width = 1;
   parameter C = 0;
   parameter P = 0;

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en;

   reg [width-1:0] q, q1;

   always @(posedge clk)
   begin
      if (en)
      begin
         q1 = d;
         #C;
         q = q1 + 1'bx;
         #(P-C);
         q = q1;
      end
   end

endmodule


