/* tflopenld.v
 *
 * a T flip-flop with Enable and Load
 *  ( ld overrides en )
 *
 * Luis F. G. Sarmenta 950404.1926
 *
 */

module tflopenld( q, clk, d, en, ld );

   parameter width = 1;

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en, ld;

   reg [width-1:0] q;

   always @(posedge clk)
   begin
      case (ld)
            0 : q = en ? ~q : q;
            1 : q = d;
      endcase
   end


endmodule


